ORCA/M Asm65816 2.1.0

0001 E701
0002 E701                       title 'List Manager' 
0003 E701              *************************************************************************
0004 E701              *
0005 E701              * List Manager Version 3.2 
0006 E701              * written by Dan Oliver
0007 E701              *
0008 E701              * Copyright Apple Computer, Inc. 1986-93
0009 E701              * All Rights Reserved
0010 E701              *
0011 E701              *
0012 E701              * Change History
0013 E701              *
0014 E701              * Version 2.3
0015 E701              *
0016 E701              *
0017 E701              * June 17, 1988     Harry Yee
0018 E701              *                   Converted to MAX development system.
0019 E701              *
0020 E701              *
0021 E701              * Version 2.4
0022 E701              *
0023 E701              * 30 Aug 88         Steven Glass
0024 E701              *
0025 E701              * WalkOfLife does not use self modifying code.
0026 E701              *
0027 E701              * List_Drag used in-line data storage for the event record.  This
0028 E701              * has been changed to use the stack.
0029 E701              *
0030 E701              * We also have added an additional word in the direct page area
0031 E701              * that we get inside the def-proc.
0032 E701              *
0033 E701              * Finally, the init routine used in line storage to pass a pointer
0034 E701              * to the color table pointer used by the scroll bar.  To pass this
0035 E701              * cleanly, we put it in the RefCon and after the scroll bar is created,
0036 E701              * we reset the refcon to the user's value.
0037 E701              *
0038 E701              * Version 2.5
0039 E701              *
0040 E701              * 21 November 88    Owen Rubin
0041 E701              *
0042 E701              * SelectMember use to scroll the item to the top of the display list EVEN
0043 E701              * if the item was already showing in the display. This change prevents the
0044 E701              * selected item from moving to the top of the list if it is already visible.
0045 E701              *
0046 E701              * A new bit (D5) has been added to the flags field. When set to 1, this bit
0047 E701              * prevents an item from EVER having its selected bit set by the list manager.
0048 E701              * (Note that this disables any use of the help function.)
0049 E701              *
0050 E701              * 07 December 88    Konstantin Othmer
0051 E701              *
0052 E701              * Fixed bug to make list manager work properly with Newcontrol2.  The list_init
0053 E701              *  routine now initializes ctlflag word in the NewCtlRecord.  So it now supports
0054 E701              *  C-strings and whether or not multiple selections are allowed.  Both of these
0055 E701              *  bits are in the listType field. Almost fully functional with NewControl2
0056 E701              *
0057 E701              * 08 December 88    Konstantin 
0058 E701              *
0059 E701              * The scroll bars were not being initialized properly.  Now the ListMgr is fully
0060 E701              *  functional with NewControl2.
0061 E701              *
0062 E701              *  Changed internal call numbers to $8xxx so they don't overlap with NewControl2
0063 E701              * operation numbers.
0064 E701              *
0065 E701              *  Made bit 2 of the ListType field control whether the scroll bar goes on the
0066 E701              * inside (bit2 = 1) or the outside (bit2 = 0) of the listrect.
0067 E701              *
0068 E701              * 23 January 89     Konstantin 
0069 E701              *
0070 E701              * The scroll bars for list controls can use only the default color table.  The
0071 E701              *  colors were determined by the refcon before this change.
0072 E701              *
0073 E701              * 25 January 89     Harry
0074 E701              *
0075 E701              * In routine derefMem we first check to see if the list is an old or new style 
0076 E701              * control before checking the memflag to see if the member is a ptr, hdl, or 
0077 E701              * resource ID. Change made mainly because of incompatibility between old Print
0078 E701              * Manager and new List Manager.
0079 E701              *
0080 E701              * In routine ck_deselected we now check if bit 6 of the control record's flag
0081 E701              * is set before we check the list manager's MEM_NEVER bit in the memFlag. 
0082 E701              *
0083 E701              * 10 February 89    Harry
0084 E701              *
0085 E701              * In routine LIST_INIT the list control's invisible bit in the ctlFlag is being 
0086 E701              * overwritten by the ListType flag. The fix is to OR the ListType flag with
0087 E701              * the ctlFlag. When the scroll bar is being created the scroll bar's visible bit
0088 E701              * must be set to the same state as the list control's.
0089 E701              *
0090 E701              * Modified LIST_DRAW routine to draw the scroll bar if the list control is visible
0091 E701              * but the scroll bar isn't. 
0092 E701              *
0093 E701              * List Control's did not work with the call _HideControl because the scroll bar rect
0094 E701              * was not part of the list control's rect. I now support the new control 
0095 E701              * message ctlHideCntl (message #18). This defproc is called by _HideControl if the 
0096 E701              * FctlIsMultiPart bit is set in moreFlags. This new message now allows the defproc to 
0097 E701              * erase whatever it needs. The defproc is also responsible for setting the invisible
0098 E701              * bit for each control including the list control.
0099 E701              *
0100 E701              * 17 Feb 89         Harry and Konstantine
0101 E701              *
0102 E701              * The color table for new list controls were not being copied into the control
0103 E701              * record. Fixed.
0104 E701              *
0105 E701              * 24 Mar 89         Harry Yee
0106 E701              *
0107 E701              * Fixed problem in routine List_hide. I was calculating the rectangle to be used
0108 E701              * to hide the list control incorrectly. I was adding the x2 coord. of the list to 
0109 E701              * the x2 coord. of the scroll bar to get the x2 coord. for the rect. Instead I 
0110 E701              * should just have used the x2 coord. from the scroll bar. Worksheet #BCOJHS090.
0111 E701              *
0112 E701              * 28 mar 89         Steven Glass
0113 E701              *
0114 E701              * Added support for the WinStateChange message.  This code ignores it
0115 E701              * because the control does not look any different in active and inactive
0116 E701              * windows.
0117 E701              *
0118 E701              * 29 Mar 89         Harry Yee
0119 E701              *
0120 E701              * Changed routine list_hide to list_MultiPart. Changed list_MultiPart to handle
0121 E701              * changes made to the control manager. There are now 4 possible Parameter values.
0122 E701              * This routine now also gets called during a ShowControl and DrawOneCtl call.
0123 E701              *
0124 E701              * 4/14/89           Mensch
0125 E701              *
0126 E701              * Changed list_init in the defproc so that the initial scroll bar value matches
0127 E701              * the top item in the list.
0128 E701              *
0129 E701              * 17 Apr 89         Harry Yee
0130 E701              *
0131 E701              * In routine LockNLoad we were not first checking whether the control message was
0132 E701              * InitCntl before trying to access some control record fields which at this pt
0133 E701              * may not have been setup by list_init yet. 
0134 E701              *
0135 E701              * Routine WalkOfLife was looping one too many times. This caused problems because
0136 E701              * we were walking past the end of the list and trying to access a list member that
0137 E701              * didn't exist. Fixed. This caused problems in DrawPlus when calling ChooseFont.
0138 E701              *
0139 E701              * Routine Draw1Member was running off the end of the list. We would push the count 
0140 E701              * on the stack then call routine DerefMem then decrement the count and check if we've 
0141 E701              * went past the list. If we did reach the end of the list then we called DerefMem one 
0142 E701              * two many times. We now put the check for count before calling DerefMem. Fixes same
0143 E701              * problem as above.
0144 E701              *
0145 E701              * In the init routine, we validate the first member to display with
0146 E701              * respect to the view size and data size.  First member <= DataSize - ViewSize.
0147 E701              *
0148 E701              * 19 Apr 89         Harry Yee
0149 E701              *
0150 E701              * Changed version number from $8204 to $0300. 
0151 E701              **************************************************************************
0152 E701
0153 E701                       Blanks off 
0154 E701                       string asis 
0155 E701                       include 'all.macros' 
0156 E701                       include 'e16.event' 
0157 E701
0158 E701                       print push 
0159 E701                       print off 
0160 E701
0161 E701                       include 'ListEquates.asm' 
0162 E701                       include  '::controlmgr:superequates.asm' 
0163 E701
0164 E701
0165 E701              ;-----------------------------------------------
0166 E701              ;
0167 E701              ;   Forward addresses and entries
0168 E701              ;
0169 E701              ;-----------------------------------------------
0170 E701
0171 E701                       ENTRY CallDefProc
0172 E701                       ENTRY CallDefProc2
0173 E701                       ENTRY ItemNumToPointer
0174 E701                       ENTRY PointerToItemNum
0175 E701                       ENTRY DrawMember2
0176 E701                       ENTRY ck_Deselected
0177 E701                       ENTRY CreateList
0178 E701                       ENTRY DerefMem
0179 E701                       ENTRY DrawMember
0180 E701                       ENTRY EndDraw
0181 E701                       ENTRY EraseRect
0182 E701                       ENTRY Exit_tool
0183 E701                       ENTRY FindFirst
0184 E701                       ENTRY GetListDefProc
0185 E701                       ENTRY GetListRect
0186 E701                       ENTRY GetMemPtr
0187 E701                       ENTRY HitTest
0188 E701                       ENTRY InsetCRect
0189 E701                       ENTRY ListAction
0190 E701                       ENTRY ListBootInit
0191 E701                       ENTRY ListProc
0192 E701                       ENTRY ListReset
0193 E701                       ENTRY ListShutDown
0194 E701                       ENTRY ListStartup
0195 E701                       ENTRY ListStatus
0196 E701                       ENTRY ListVersion
0197 E701                       ENTRY LockNLoad
0198 E701                       ENTRY List_action
0199 E701                       ENTRY List_disp
0200 E701                       ENTRY List_drag
0201 E701                       ENTRY List_dragParam
0202 E701                       ENTRY List_dragRect
0203 E701                       ENTRY List_HandleEvent
0204 E701                       ENTRY List_ChangeActivity 
0205 E701                       ENTRY List_ChangeBounds
0206 E701                       ENTRY List_WindChangeSize
0207 E701                       ENTRY List_HandleTab
0208 E701                       ENTRY List_ChangeWinState
0209 E701                       ENTRY List_Draw
0210 E701                       ENTRY List_MultiPart
0211 E701                       ENTRY List_DrawMem
0212 E701                       ENTRY List_First
0213 E701                       ENTRY List_init
0214 E701                       ENTRY List_move
0215 E701                       ENTRY List_new
0216 E701                       ENTRY List_params
0217 E701                       ENTRY List_pos
0218 E701                       ENTRY List_test
0219 E701                       ENTRY List_value
0220 E701                       ENTRY Long_call
0221 E701                       ENTRY NewList
0222 E701                       ENTRY NewList2
0223 E701                       ENTRY NextMember
0224 E701                       ENTRY NextMember2
0225 E701                       ENTRY Pop8bytes
0226 E701                       ENTRY PushCRect
0227 E701                       ENTRY PushParam
0228 E701                       ENTRY PushRec
0229 E701                       ENTRY Reserved
0230 E701                       ENTRY ResetMember
0231 E701                       ENTRY ResetMember2
0232 E701                       ENTRY SetNewValue
0233 E701                       ENTRY LST_Scroll
0234 E701                       ENTRY SelectMember
0235 E701                       ENTRY SelectMember2
0236 E701                       ENTRY SetColor
0237 E701                       ENTRY SetColor2
0238 E701                       ENTRY SetOldClip
0239 E701                       ENTRY SortList
0240 E701                       ENTRY SortList2
0241 E701                       ENTRY UnlockList
0242 E701                       ENTRY WalkOfLife
0243 E701                       ENTRY LockNDerefList
0244 E701                       entry GetMPoint
0245 E701
0246 E701                       print pop 
0247 E701
0248 E701                       title 'ListCallTable' 
0249 E701              ;=============================================================
0250 E701              ;
0251 E701              ;                   List Manager Function Table
0252 E701              ;
0253 E701              ;=============================================================
0254 E701
0255 E701              ListCallTable PROC EXPORT 
0256 E701
0257 E701 17 00        FPT      DC W:(ENDFPT-FPT)/4
0258 E703 00 00                 DC W:0
0259 E705 C5 E8 FC 00           DC L:ListBootInit-1            $011C
0260 E709 C5 E8 FC 00           DC L:ListStartup-1             $021C
0261 E70D C5 E8 FC 00           DC L:ListShutDown-1            $031C
0262 E711 5C E7 FC 00           DC L:ListVersion-1             $041C
0263 E715 C5 E8 FC 00           DC L:ListReset-1               $051C
0264 E719 61 E7 FC 00           DC L:ListStatus-1              $061C
0265 E71D C5 E8 FC 00           DC L:Reserved-1                $071C
0266 E721 C5 E8 FC 00           DC L:Reserved-1                $081C
0267 E725 F6 E7 FC 00           DC L:CreateList-1              $091C
0268 E729 CA E8 FC 00           DC L:SortList-1                $0A1C
0269 E72D 06 EA FC 00           DC L:NextMember-1              $0B1C
0270 E731 28 EA FC 00           DC L:DrawMember-1              $0C1C
0271 E735 38 EA FC 00           DC L:SelectMember-1            $0D1C
0272 E739 69 E7 FC 00           DC L:GetListDefProc-1          $0E1C
0273 E73D EF E9 FC 00           DC L:ResetMember-1             $0F1C
0274 E741 76 E7 FC 00           DC L:NewList-1                 $101C
0275 E745              *** List Manager 2 calls
0276 E745 5A EC FC 00           DC L:DrawMember2-1             ;$111C
0277 E749 79 EC FC 00           DC L:NextMember2-1             ;$121C
0278 E74D C0 EC FC 00           DC L:ResetMember2-1            ;$131C
0279 E751 F0 EC FC 00           DC L:SelectMember2-1           ;$141C
0280 E755 FD EE FC 00           DC L:SortList2-1               ;$151C
0281 E759 99 ED FC 00           DC L:NewList2-1                ;$161C
0282 E75D
0283 E75D              ENDFPT     
0284 E75D                       ENDP 
0285 E75D
0286 E75D
0287 E75D                       Title 'List--more' 
0288 E75D              ;==========================================================================
0289 E75D              ;
0290 E75D              ;            APPEND LISTMGR.ASM
0291 E75D              ;
0292 E75D              ; 06/05/87 Dan - Force ListStart to be ((ListSize-ListView)+1) or less.
0293 E75D              ;
0294 E75D              ;==========================================================================
0295 E75D              ;
0296 E75D              ;                   ListVersion
0297 E75D              ;
0298 E75D              ;                   List Manager Version and Status calls.
0299 E75D              ;
0300 E75D              ;==========================================================================
0301 E75D                       ENTRY ListVersion
0302 E75D              ListVersion PROC 
0303 E75D
0304 E75D              TheResult equ   7
0305 E75D
0306 E75D A9 00 03              lda   #$0300                   ;Version number
0307 E760 80 03                 bra   store
0308 E762
0309 E762                       ENTRY ListStatus
0310 E762              ListStatus  
0311 E762                                                      ;List Manager is always active if loaded.
0312 E762 A9 02 00              lda   #2                       ;Dan O. version number.
0313 E765
0314 E765 83 07        store    sta   TheResult,s
0315 E767 82 5C 01              brl   exit_tool
0316 E76A
0317 E76A                       ENDP 
0318 E76A
0319 E76A
0320 E76A              ;==========================================================================
0321 E76A              ;
0322 E76A              ;                   GetListDefProc
0323 E76A              ;
0324 E76A              ;                   Return the address of the list definition procedure.
0325 E76A              ;
0326 E76A              ;   IN:    None.
0327 E76A              ;
0328 E76A              ;  OUT:    Address of list definition procedure.
0329 E76A              ;
0330 E76A              ;==========================================================================
0331 E76A                       ENTRY GetListDefProc
0332 E76A              GetListDefProc PROC 
0333 E76A
0334 E76A              TheResult equ   7
0335 E76A
0336 E76A A9 FC 00              lda   #ListProc>>16            Pass pointer to list control defProc.
0337 E76D 83 09                 sta   TheResult+2,s
0338 E76F A9 E9 F0              lda   #ListProc
0339 E772 83 07                 sta   TheResult,s
0340 E774
0341 E774 82 4F 01              brl   exit_tool
0342 E777
0343 E777                       ENDP 
0344 E777
0345 E777
0346 E777              ;==========================================================================
0347 E777              ;
0348 E777              ;                   NewList
0349 E777              ;
0350 E777              ;                   Put a new list in a list control.
0351 E777              ;
0352 E777              ;   IN:    PUSH:LONG - pointer to ListRec.
0353 E777              ;
0354 E777              ;  OUT:    None.
0355 E777              ;
0356 E777              ;==========================================================================
0357 E777                       ENTRY NewList
0358 E777              NewList  PROC 
0359 E777
0360 E777              theList  equ   9
0361 E777              member   equ   theList+4
0362 E777
0363 E777 0B                    phd   
0364 E778 3B                    tsc   
0365 E779 5B                    tcd   
0366 E77A
0367 E77A A5 09                 lda   <theList                 Pass list pointer.
0368 E77C A6 0B                 ldx   <theList+2
0369 E77E 20 B5 E7              jsr   flipVis                  Make list control invisible.
0370 E781
0371 E781 A9 01 80              lda   #ListNew                 New list command.
0372 E784 A6 09                 ldx   <theList                 Pass list record pointer.
0373 E786 A4 0B                 ldy   <theList+2
0374 E788 20 C0 F0              jsr   callDefProc
0375 E78B
0376 E78B D4 0F                 pei   <member+2                Pass member to be selected.
0377 E78D D4 0D                 pei   <member
0378 E78F D4 0B                 pei   <theList+2               Pass pointer to list record.
0379 E791 D4 09                 pei   <theList
0380 E793 A2 1C 0D 22           _SelectMember 
0381 E79A
0382 E79A A5 09                 lda   <theList                 Pass list pointer.
0383 E79C A6 0B                 ldx   <theList+2
0384 E79E 20 B5 E7              jsr   flipVis                  Make list control visible.
0385 E7A1
0386 E7A1 DA                    phx                            Pass handle of scroll bar control.
0387 E7A2 48                    pha   
0388 E7A3 A2 10 25 22           _DrawOneCtl                    Redraw the scroll bar.
0389 E7AA
0390 E7AA A9 00 00              lda   #0                       Draw command.
0391 E7AD AA                    tax                            Entire list command.
0392 E7AE A8                    tay   
0393 E7AF 20 C0 F0              jsr   callDefProc
0394 E7B2
0395 E7B2 82 F7 00              brl   pop8bytes
0396 E7B5
0397 E7B5              ;---------------------------------------------------------------
0398 E7B5              ;          Flip vis state of list and scroll bar.
0399 E7B5              ;100------------------------------------------------------------
0400 E7B5              ;
0401 E7B5              temp     equ   1
0402 E7B5              ;
0403 E7B5 0B           flipVis  phd   
0404 E7B6 DA                    phx                            List pointer.
0405 E7B7 48                    pha   
0406 E7B8 3B                    tsc   
0407 E7B9 5B                    tcd   
0408 E7BA
0409 E7BA A0 12 00              ldy   #ListCtl+2               Flip vis state of list.
0410 E7BD B7 01                 lda   [<temp],y
0411 E7BF AA                    tax   
0412 E7C0 88                    dey   
0413 E7C1 88                    dey   
0414 E7C2 B7 01                 lda   [<temp],y
0415 E7C4 20 DC E7              jsr   flipit
0416 E7C7
0417 E7C7 A0 36 00              ldy   #CtlListBar+2            Flip vis state of scroll bar.
0418 E7CA B7 01                 lda   [<temp],y
0419 E7CC AA                    tax   
0420 E7CD 88                    dey   
0421 E7CE 88                    dey   
0422 E7CF B7 01                 lda   [<temp],y
0423 E7D1 DA                    phx                            Save scroll bar handle.
0424 E7D2 48                    pha   
0425 E7D3 20 DC E7              jsr   flipit
0426 E7D6 68                    pla                            Return handle of scroll bar.
0427 E7D7 FA                    plx   
0428 E7D8
0429 E7D8 7A                    ply   
0430 E7D9 7A                    ply   
0431 E7DA 2B                    pld   
0432 E7DB 60                    rts   
0433 E7DC
0434 E7DC 85 01        flipit   sta   <temp                    Store control handle.
0435 E7DE 86 03                 stx   <temp+2
0436 E7E0
0437 E7E0 A0 02 00              ldy   #2                       Dereference control.
0438 E7E3 B7 01                 lda   [<temp],y
0439 E7E5 A8                    tay   
0440 E7E6 A7 01                 lda   [<temp]
0441 E7E8 85 01                 sta   <temp
0442 E7EA 84 03                 sty   <temp+2
0443 E7EC
0444 E7EC A0 10 00              ldy   #CtlFlag                 Flip vis state.
0445 E7EF B7 01                 lda   [<temp],y
0446 E7F1 49 80 00              eor   #$0080
0447 E7F4 97 01                 sta   [<temp],y
0448 E7F6 60                    rts   
0449 E7F7
0450 E7F7                       ENDP 
0451 E7F7
0452 E7F7
0453 E7F7              ;==========================================================================
0454 E7F7              ;
0455 E7F7              ;                   CreateList
0456 E7F7              ;
0457 E7F7              ;                   Create a list control.
0458 E7F7              ;
0459 E7F7              ;   IN:    PUSH:LONG - pointer to window owner.
0460 E7F7              ;          PUSH:LONG - pointer to ListRec.
0461 E7F7              ;
0462 E7F7              ;  OUT:    LONG - handle of list control created, zero if not created.
0463 E7F7              ;
0464 E7F7              ; The pointer to color table for the scroll bar was put in a global in-line variable
0465 E7F7              ; and used in the init routine for the scroll bar's color table.  We
0466 E7F7              ; now pass the pointer to the init routine in the refcon of the list
0467 E7F7              ; control.
0468 E7F7              ;
0469 E7F7              ;==========================================================================
0470 E7F7                       ENTRY CreateList
0471 E7F7              CreateList PROC 
0472 E7F7              ;
0473 E7F7              theList  equ   9
0474 E7F7              theWindow equ   theList+4
0475 E7F7              TheResult equ   theWindow+4
0476 E7F7
0477 E7F7 0B                    phd   
0478 E7F8 3B                    tsc   
0479 E7F9 5B                    tcd   
0480 E7FA              ;
0481 E7FA              ; If listView size is zero, we calculate listview.  Otherwise we assume the user
0482 E7FA              ; knows what he is doing, because I sure as hell don't.
0483 E7FA              ;
0484 E7FA A0 0A 00              ldy   #ListView
0485 E7FD B7 09                 lda   [<theList],y             ;can't be less than the starting member.
0486 E7FF D0 32                 bne   ViewIsSet                ;if non-zero, ListView was set by programmer.
0487 E801              ;
0488 E801              ; Calculate ListView (the number of items which can be seen at once) by dividing
0489 E801              ; the height of the rectangle by listMemHeight.
0490 E801              ;
0491 E801 48                    pha   
0492 E802 48                    pha                            ;space for result of divide
0493 E803
0494 E803 A0 04 00              ldy   #listRect+y2
0495 E806 B7 09                 lda   [<theList],y
0496 E808 A0 00 00              ldy   #listRect+y1
0497 E80B 38                    sec   
0498 E80C F7 09                 sbc   [<theList],y
0499 E80E 48                    pha                            ;height of list record
0500 E80F A0 18 00              ldy   #listMemHeight
0501 E812 B7 09                 lda   [<theList],y             ;height of members
0502 E814 48                    pha   
0503 E815 A2 0B 0B 22           _UDivide 
0504 E81C 68                    pla                            ;quotient
0505 E81D A0 0A 00              ldy   #ListView
0506 E820 97 09                 sta   [<theList],y
0507 E822 68                    pla                            ;remainder
0508 E823 38                    sec   
0509 E824 E9 02 00              sbc   #2
0510 E827              ;
0511 E827              ; The parameters don't jive.  Subtract the remainder from listRec+y2 so they
0512 E827              ; do.
0513 E827              ;
0514 E827 48                    pha   
0515 E828 A0 04 00              ldy   #listRect+y2
0516 E82B B7 09                 lda   [<theList],y
0517 E82D 38                    sec   
0518 E82E E3 01                 sbc   1,s
0519 E830 97 09                 sta   [<theList],y
0520 E832 68                    pla   
0521 E833
0522 E833
0523 E833              ViewIsSet  
0524 E833              ;
0525 E833              ; --- Create the list control --------------------------------------------
0526 E833              ;
0527 E833 48                    pha                            Space for result.
0528 E834 48                    pha   
0529 E835
0530 E835 D4 0F                 pei   <theWindow+2             Pass window owner.
0531 E837 D4 0D                 pei   <theWindow
0532 E839
0533 E839 D4 0B                 pei   <theList+2               Pass pointer to enclosing RECT.
0534 E83B D4 09                 pei   <theList
0535 E83D
0536 E83D A0 06 00              ldy   #ListSize-2              Pass number of members in list,
0537 E840 C8           lop1     iny                            view size,
0538 E841 C8                    iny                            flag,
0539 E842 B7 09                 lda   [<theList],y             first member in display.
0540 E844 48                    pha   
0541 E845 C0 0E 00              cpy   #ListStart
0542 E848 D0 F6                 bne   lop1
0543 E84A
0544 E84A A0 08 00              ldy   #ListSize                Total size,
0545 E84D B7 09                 lda   [<theList],y
0546 E84F F0 13                 beq   store1
0547 E851
0548 E851 A0 0A 00              ldy   #ListView
0549 E854 38                    sec                            less view size,
0550 E855 F7 09                 sbc   [<theList],y             can't be less than the starting member.
0551 E857 B0 03                 bcs   ok1                      Is the view larger than the list?
0552 E859 A9 00 00              lda   #0                       Set minimum starting value.
0553 E85C 1A           ok1      inc   a
0554 E85D A0 0E 00              ldy   #ListStart
0555 E860 D7 09                 cmp   [<theList],y
0556 E862 B0 02                 bcs   skip1
0557 E864
0558 E864 83 01        store1   sta   1,s                      Reset start value.
0559 E866
0560 E866 D4 09        skip1    pei   <theList                 Pass pointer to ListRec.
0561 E868 D4 0B                 pei   <theList+2
0562 E86A
0563 E86A F4 FC 00              pea   ListProc>>16             Pass pointer to list control defProc.
0564 E86D F4 E9 F0              pea   ListProc
0565 E870
0566 E870 A0 26 00              ldy   #ListScrollClr+2
0567 E873 B7 09                 lda   [<theList],y
0568 E875 48                    pha   
0569 E876 88                    dey   
0570 E877 88                    dey   
0571 E878 B7 09                 lda   [<theList],y
0572 E87A 48                    pha   
0573 E87B
0574 E87B A9 00 00              lda   #0
0575 E87E 48                    pha                            Pass pointer to color table, default.
0576 E87F 48                    pha   
0577 E880 A2 10 09 22           _NewControl 
0578 E887 68                    pla                            Return handle of control.
0579 E888 85 11                 sta   <TheResult
0580 E88A A0 10 00              ldy   #ListCtl
0581 E88D 97 09                 sta   [<theList],y
0582 E88F 68                    pla   
0583 E890 85 13                 sta   <TheResult+2
0584 E892 C8                    iny   
0585 E893 C8                    iny   
0586 E894 97 09                 sta   [<theList],y
0587 E896
0588 E896
0589 E896 A0 22 00              ldy   #ListRefCon+2            Set user's ref con over our temporary one.
0590 E899 B7 09                 lda   [<theList],y
0591 E89B 48                    pha   
0592 E89C 88                    dey   
0593 E89D 88                    dey   
0594 E89E B7 09                 lda   [<theList],y
0595 E8A0 48                    pha   
0596 E8A1 D4 13                 pei   <TheResult+2
0597 E8A3 D4 11                 pei   <TheResult
0598 E8A5 A2 10 22 22           _SetCtlRefCon 
0599 E8AC
0600 E8AC
0601 E8AC                       ENTRY pop8bytes
0602 E8AC A2 08 00     pop8bytes ldx   #8
0603 E8AF
0604 E8AF
0605 E8AF              ; = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = =
0606 E8AF              ;
0607 E8AF              ;                   Pop
0608 E8AF              ;
0609 E8AF              ;                   Pop parameters from middle of stack.
0610 E8AF              ;
0611 E8AF              ;  IN:     x = number of bytes to pop.
0612 E8AF              ;          Original zero page must have been pushed.
0613 E8AF              ;
0614 E8AF              ; = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = =
0615 E8AF                       ENTRY pop
0616 E8AF              pop       
0617 E8AF
0618 E8AF 7A                    ply                            Get orignal zero page.
0619 E8B0              ;
0620 E8B0              ; --- Move stack data down over top of parameters ---
0621 E8B0              ;
0622 E8B0 3B                    tsc   
0623 E8B1 5B                    tcd                            Make zero page where stack is.
0624 E8B2 A3 05                 lda   5,s
0625 E8B4 95 05                 sta   5,x
0626 E8B6 A3 03                 lda   3,s
0627 E8B8 95 03                 sta   3,x
0628 E8BA A3 01                 lda   1,s
0629 E8BC 95 01                 sta   1,x
0630 E8BE              ;
0631 E8BE              ; --- Adjust stact for popped parameters ---
0632 E8BE              ;
0633 E8BE 3B                    tsc                            Current stack,
0634 E8BF DA                    phx   
0635 E8C0 18                    clc   
0636 E8C1 63 01                 adc   1,s                      plus number of bytes popped,
0637 E8C3 1B                    tcs                            equals new stack.
0638 E8C4
0639 E8C4 98                    tya   
0640 E8C5 5B                    tcd                            Return to original zero page.
0641 E8C6
0642 E8C6              ;==========================================================================
0643 E8C6              ;
0644 E8C6              ;                   ListStartup
0645 E8C6              ;                   ListShutDown
0646 E8C6              ;                   ListReset
0647 E8C6              ;                   ListBootInit
0648 E8C6              ;                   Reserved
0649 E8C6              ;                   exit_tool
0650 E8C6              ;
0651 E8C6              ;==========================================================================
0652 E8C6                       ENTRY ListStartup
0653 E8C6              ListStartup  
0654 E8C6
0655 E8C6                       ENTRY ListShutDown
0656 E8C6              ListShutDown  
0657 E8C6                       ENTRY ListReset
0658 E8C6              ListReset  
0659 E8C6                       ENTRY ListBootInit
0660 E8C6              ListBootInit  
0661 E8C6                       ENTRY Reserved
0662 E8C6              Reserved  
0663 E8C6                       ENTRY exit_tool
0664 E8C6              exit_tool  
0665 E8C6
0666 E8C6 18                    clc                            Set no error flag just in case.
0667 E8C7 A9 00 00              lda   #0                       No error.
0668 E8CA 6B                    rtl   
0669 E8CB
0670 E8CB                       ENDP 
0671 E8CB
0672 E8CB
0673 E8CB              ;==========================================================================
0674 E8CB              ;
0675 E8CB              ;                   SortList
0676 E8CB              ;
0677 E8CB              ;                   Alphabetize list.
0678 E8CB              ;
0679 E8CB              ;   IN:    PUSH:LONG - address of routine to call to compare strings.
0680 E8CB              ;          PUSH:LONG - pointer to ListRec.
0681 E8CB              ;
0682 E8CB              ;  OUT:    None.
0683 E8CB              ;==========================================================================
0684 E8CB                       ENTRY SortList
0685 E8CB              SortList PROC 
0686 E8CB
0687 E8CB                       import upcase8 
0688 E8CB
0689 E8CB              memSize  equ   1
0690 E8CB              stringType equ   memSize+2
0691 E8CB              counter  equ   stringType+2
0692 E8CB              save     equ   counter+2
0693 E8CB              blit     equ   save+4
0694 E8CB              strg1    equ   blit+4
0695 E8CB              strg2    equ   strg1+4
0696 E8CB              listptr  equ   strg2+4
0697 E8CB              current  equ   listptr+4
0698 E8CB              gopher   equ   current+2
0699 E8CB              worksize equ   gopher+1
0700 E8CB
0701 E8CB              listrec  equ   worksize+9
0702 E8CB              UseCompare equ   listrec+4
0703 E8CB
0704 E8CB              ACC      equ   $20
0705 E8CB              XY       equ   $10
0706 E8CB
0707 E8CB
0708 E8CB 0B                    phd                            Save orginal direct page.
0709 E8CC
0710 E8CC 3B                    tsc   
0711 E8CD 38                    sec   
0712 E8CE E9 1E 00              sbc   #worksize
0713 E8D1 1B                    tcs   
0714 E8D2 5B                    tcd   
0715 E8D3
0716 E8D3              ;
0717 E8D3              ; --- Bubble sort member list -----------------------------------------
0718 E8D3              ;
0719 E8D3 A0 08 00              ldy   #ListSize
0720 E8D6 B7 27                 lda   [<listrec],y
0721 E8D8 F0 03                 beq   toexit                   There must be at least two members.
0722 E8DA 3A                    dec   a
0723 E8DB D0 03                 bne   store3                   There must be at least two members.
0724 E8DD 82 89 00     toexit   brl   exit
0725 E8E0 85 05        store3   sta   <counter                 Total number of members less one.
0726 E8E2
0727 E8E2 A0 1A 00              ldy   #ListMemSize             Get size of member record.
0728 E8E5 B7 27                 lda   [<listrec],y
0729 E8E7 85 01                 sta   <memSize
0730 E8E9
0731 E8E9 A0 0C 00              ldy   #ListType
0732 E8EC B7 27                 lda   [<listrec],y
0733 E8EE 29 01 00              and   #1
0734 E8F1 85 03                 sta   <stringType              0 = pascal strings, 1 = null terminated.
0735 E8F3
0736 E8F3 20 E1 E9              jsr   getmemlist               listptr = pointer to member list.
0737 E8F6 38                    sec                            Set pointer for easy block moves.
0738 E8F7 E5 01                 sbc   <memSize
0739 E8F9 B0 01                 bcs   store2
0740 E8FB CA                    dex   
0741 E8FC 85 0B        store2   sta   <blit
0742 E8FE 86 0D                 stx   <blit+2
0743 E900
0744 E900 64 1D                 stz   <gopher                  Gopher is always at least one behind.
0745 E902 64 1B                 stz   <current
0746 E904 80 07                 bra   enter1
0747 E906
0748 E906 A5 1D        lop1     lda   <gopher                  Next gopher index.
0749 E908 18                    clc   
0750 E909 65 01                 adc   <memSize
0751 E90B 85 1D                 sta   <gopher
0752 E90D
0753 E90D A5 1B        enter1   lda   <current                 Next current index.
0754 E90F 18                    clc   
0755 E910 65 01                 adc   <memSize
0756 E912 85 1B                 sta   <current
0757 E914
0758 E914 20 72 E9              jsr   compare                  Is 'current' >= 'gopher'?
0759 E917 B0 49                 bcs   next1
0760 E919
0761 E919              ;
0762 E919              ; ------ Float 'current' to it's proper level -----------------------------
0763 E919              ;
0764 E919 A5 1D        lop2     lda   <gopher                  Backup gopher.
0765 E91B F0 11                 beq   insert                   At top of list?
0766 E91D 38                    sec   
0767 E91E E5 01                 sbc   <memSize
0768 E920 85 1D                 sta   <gopher
0769 E922
0770 E922 20 72 E9              jsr   compare                  Is this 'current's place?
0771 E925 90 F2                 bcc   lop2                     If not, keep rising to the top.
0772 E927
0773 E927 A5 1D                 lda   <gopher                  Insert 'current' after 'gopher'
0774 E929 18                    clc   
0775 E92A 65 01                 adc   <memSize
0776 E92C 85 1D                 sta   <gopher
0777 E92E
0778 E92E E2 20        insert   sep   #ACC                     Save 'current' member.
0779 E930 A6 01                 ldx   <memSize
0780 E932 A4 1B                 ldy   <current
0781 E934 B7 17        lop4     lda   [<listptr],y
0782 E936 48                    pha   
0783 E937 C8                    iny   
0784 E938 CA                    dex   
0785 E939 D0 F9                 bne   lop4
0786 E93B 88                    dey   
0787 E93C
0788 E93C B7 0B        lop3     lda   [<blit],y                Move list down to make
0789 E93E 97 17                 sta   [<listptr],y             space for 'current'.
0790 E940 88                    dey   
0791 E941 C4 1D                 cpy   <gopher
0792 E943 D0 F7                 bne   lop3
0793 E945
0794 E945 C2 20                 rep   #ACC
0795 E947 A5 1D                 lda   <gopher
0796 E949 18                    clc   
0797 E94A 65 01                 adc   <memSize
0798 E94C 3A                    dec   a
0799 E94D A8                    tay   
0800 E94E E2 20                 sep   #ACC
0801 E950 A6 01                 ldx   <memSize
0802 E952 68           lop5     pla   
0803 E953 97 17                 sta   [<listptr],y
0804 E955 88                    dey   
0805 E956 CA                    dex   
0806 E957 D0 F9                 bne   lop5
0807 E959 C2 20                 rep   #ACC
0808 E95B
0809 E95B A5 1B                 lda   <current                 Reset 'gopher'.
0810 E95D 38                    sec   
0811 E95E E5 01                 sbc   <memSize
0812 E960 85 1D                 sta   <gopher
0813 E962
0814 E962 C6 05        next1    dec   <counter                 Anymore members?
0815 E964 D0 A0                 bne   lop1
0816 E966
0817 E966 20 E1 E9              jsr   getmemlist               Unlock member list.
0818 E969
0819 E969 3B           exit     tsc                            Get rid of local stack space.
0820 E96A 18                    clc   
0821 E96B 69 1E 00              adc   #worksize
0822 E96E 1B                    tcs   
0823 E96F
0824 E96F 82 3A FF              brl   pop8bytes
0825 E972
0826 E972
0827 E972              ; = = = = = = = = = = = = = = = = = = = = = = = = = =
0828 E972              ;          Compare 'current' member string
0829 E972              ;          to 'gopher' member string.
0830 E972              ; = = = = = = = = = = = = = = = = = = = = = = = = = =
0831 E972              ;
0832 E972              ;   IN:    listptr = pointer to first member in list.
0833 E972              ;          current = index to a member pointer.
0834 E972              ;          gopher = index to another member pointer.
0835 E972              ;
0836 E972              ;  OUT:    Carry is set if current member string is equal to or
0837 E972              ;          greater than gopher member string.
0838 E972              ;
0839 E972              ;          Carry is clear if current member string
0840 E972              ;          is less than gopher member string.
0841 E972              ;
0842 E972 A6 2C        compare  ldx   <UseCompare+1            Custom compare routine?
0843 E974 F0 13                 beq   skip10
0844 E976
0845 E976 A5 1D                 lda   <gopher
0846 E978 20 D4 E9              jsr   pushit
0847 E97B A5 1B                 lda   <current
0848 E97D 20 D4 E9              jsr   pushit
0849 E980 A6 2C                 ldx   <UseCompare+1
0850 E982 A5 2B                 lda   <UseCompare
0851 E984 22 E5 FA FC           jsl   long_call
0852 E988 60                    rts   
0853 E989
0854 E989
0855 E989 A4 1B        skip10   ldy   <current                 Get pointer to first string.
0856 E98B B7 17                 lda   [<listptr],y
0857 E98D 85 0F                 sta   <strg1
0858 E98F C8                    iny   
0859 E990 C8                    iny   
0860 E991 B7 17                 lda   [<listptr],y
0861 E993 85 11                 sta   <strg1+2
0862 E995
0863 E995 A4 1D                 ldy   <gopher                  Get pointer to second string.
0864 E997 B7 17                 lda   [<listptr],y
0865 E999 85 13                 sta   <strg2
0866 E99B C8                    iny   
0867 E99C C8                    iny   
0868 E99D B7 17                 lda   [<listptr],y
0869 E99F 85 15                 sta   <strg2+2
0870 E9A1
0871 E9A1                       LONGA OFF
0872 E9A1                       LONGI OFF
0873 E9A1 E2 30                 sep   #ACC+XY                  8-bit registers
0874 E9A3
0875 E9A3 A5 03                 lda   <stringType
0876 E9A5 D0 15                 bne   nullType
0877 E9A7              ;
0878 E9A7              ; --- Pascal strings ------------------------------------------------
0879 E9A7              ;
0880 E9A7 A0 00                 ldy   #0
0881 E9A9 C8           lop10    iny   
0882 E9AA
0883 E9AA 98                    tya   
0884 E9AB 3A                    dec   a
0885 E9AC C7 13                 cmp   [<strg2]                 End of gopher string?
0886 E9AE F0 1D                 beq   greater
0887 E9B0
0888 E9B0 C7 0F                 cmp   [<strg1]
0889 E9B2 F0 1C                 beq   lessthan                 End of current string?
0890 E9B4
0891 E9B4 B7 0F                 lda   [<strg1],y               Grab a byte.
0892 E9B6 D7 13                 cmp   [<strg2],y
0893 E9B8 F0 EF                 beq   lop10
0894 E9BA 80 15                 bra   exit10                   Carry flag is ready for exit.  (compared strg1 against strg2)
0895 E9BC
0896 E9BC              ;
0897 E9BC              ; --- Null terminated string -----------------------------------------
0898 E9BC              ;
0899 E9BC A0 FF        nullType ldy   #$FF
0900 E9BE C8           lop11    iny   
0901 E9BF B7 13                 lda   [<strg2],y               End of gopher string?
0902 E9C1 F0 0A                 beq   greater
0903 E9C3 B7 0F                 lda   [<strg1],y               Grab a byte.
0904 E9C5 F0 09                 beq   lessthan                 End of current string?
0905 E9C7 D7 13                 cmp   [<strg2],y
0906 E9C9 F0 F3                 beq   lop11
0907 E9CB 80 04                 bra   exit10                   Carry flag is ready for exit. 
0908 E9CD
0909 E9CD 38           greater  sec   
0910 E9CE 80 01                 bra   exit10
0911 E9D0
0912 E9D0 18           lessthan clc                            current string < gopher string.
0913 E9D1 C2 30        exit10   rep   #ACC+XY                  16-bit accumulator.
0914 E9D3                       LONGI ON
0915 E9D3                       LONGA ON
0916 E9D3
0917 E9D3 60                    rts   
0918 E9D4
0919 E9D4 FA           pushit   plx   
0920 E9D5 A4 19                 ldy   <listptr+2
0921 E9D7 18                    clc   
0922 E9D8 65 17                 adc   <listptr
0923 E9DA 90 01                 bcc   ok10
0924 E9DC C8                    iny   
0925 E9DD 5A           ok10     phy   
0926 E9DE 48                    pha   
0927 E9DF DA                    phx   
0928 E9E0
0929 E9E0 60                    rts   
0930 E9E1
0931 E9E1
0932 E9E1              ; = = = = = = = = = = = = = = = = = = = = = =
0933 E9E1              ;          Get pointer to member
0934 E9E1              ;          list and flip its lock state.
0935 E9E1              ; = = = = = = = = = = = = = = = = = = = = = =
0936 E9E1              ;
0937 E9E1              ;   IN:    listrec = pointer to ListRec.
0938 E9E1              ;
0939 E9E1              ;  OUT:    listptr = pointer to member list.
0940 E9E1              ;          member list locked.
0941 E9E1              ;
0942 E9E1 A0 1E 00     getmemlist ldy   #ListPointer+2         Get pointer to member list.
0943 E9E4 B7 27                 lda   [<listrec],y
0944 E9E6 AA                    tax   
0945 E9E7 88                    dey   
0946 E9E8 88                    dey   
0947 E9E9 B7 27                 lda   [<listrec],y
0948 E9EB 85 17                 sta   <listptr
0949 E9ED 86 19                 stx   <listptr+2
0950 E9EF
0951 E9EF 60                    rts   
0952 E9F0
0953 E9F0                       ENDP 
0954 E9F0
0955 E9F0
0956 E9F0              ;==========================================================================
0957 E9F0              ;
0958 E9F0              ;                   ResetMember
0959 E9F0              ;
0960 E9F0              ;                   Find next selected member and reset its selected member.
0961 E9F0              ;
0962 E9F0              ;   IN:    PUSH:LONG - pointer to ListRec.
0963 E9F0              ;
0964 E9F0              ;  OUT:    LONG - next selected member in list, zero if no more.
0965 E9F0              ;
0966 E9F0              ;==========================================================================
0967 E9F0                       ENTRY ResetMember
0968 E9F0              ResetMember PROC 
0969 E9F0
0970 E9F0              theList  equ   9
0971 E9F0              TheResult equ   theList+4
0972 E9F0
0973 E9F0 0B                    phd   
0974 E9F1 3B                    tsc   
0975 E9F2 5B                    tcd   
0976 E9F3
0977 E9F3 A2 00 00              ldx   #0                       Start at top of list.
0978 E9F6 9B                    txy   
0979 E9F7
0980 E9F7 A9 00 80              lda   #ListFirst               Get first selected member.
0981 E9FA 20 C0 F0              jsr   callDefProc
0982 E9FD 86 0F                 stx   <TheResult+2             Return result to caller.
0983 E9FF 85 0D                 sta   <TheResult
0984 EA01
0985 EA01                       ENTRY pop4bytes
0986 EA01              pop4bytes                               ;
0987 EA01              ;
0988 EA01 A2 04 00              ldx   #4
0989 EA04 82 A8 FE              brl   pop
0990 EA07
0991 EA07                       ENDP 
0992 EA07
0993 EA07
0994 EA07              ;==========================================================================
0995 EA07              ;
0996 EA07              ;                   NextMember
0997 EA07              ;
0998 EA07              ;                   Find next selected member.
0999 EA07              ;
1000 EA07              ;   IN:    PUSH:LONG - pointer to member to start at, zero for first member.
1001 EA07              ;          PUSH:LONG - pointer to ListRec.
1002 EA07              ;
1003 EA07              ;  OUT:    LONG - next selected member in list, zero if no more.
1004 EA07              ;
1005 EA07              ;==========================================================================
1006 EA07                       ENTRY NextMember
1007 EA07              NextMember PROC 
1008 EA07
1009 EA07              theList  equ   9
1010 EA07              member   equ   theList+4
1011 EA07              TheResult equ   member+4
1012 EA07
1013 EA07 0B                    phd   
1014 EA08 3B                    tsc   
1015 EA09 5B                    tcd   
1016 EA0A
1017 EA0A A6 0D                 ldx   <member                  Pass member to draw.
1018 EA0C A4 0F                 ldy   <member+2
1019 EA0E
1020 EA0E A9 00 80              lda   #ListFirst               Get first selected member.
1021 EA11 20 C0 F0              jsr   callDefProc
1022 EA14 86 13                 stx   <TheResult+2             Return result to caller.
1023 EA16 85 11                 sta   <TheResult
1024 EA18 05 13                 ora   <TheResult+2             Was a selected member found?
1025 EA1A F0 0A                 beq   exit                     If not, all done.
1026 EA1C
1027 EA1C A0 04 00              ldy   #memFlag                 The defProc deselected the member,
1028 EA1F B7 11                 lda   [<TheResult],y           this call wants it left alone.
1029 EA21 09 80 00              ora   #MEM_SEL
1030 EA24 97 11                 sta   [<TheResult],y
1031 EA26
1032 EA26 82 83 FE     exit     brl   pop8bytes
1033 EA29
1034 EA29                       ENDP 
1035 EA29
1036 EA29
1037 EA29              ;==========================================================================
1038 EA29              ;
1039 EA29              ;                   DrawMember
1040 EA29              ;
1041 EA29              ;                   Redraw a member.
1042 EA29              ;
1043 EA29              ;   IN:    PUSH:LONG - pointer to member to draw, zero for whole list.
1044 EA29              ;          PUSH:LONG - pointer to List.
1045 EA29              ;
1046 EA29              ;  OUT:    None.
1047 EA29              ;
1048 EA29              ;==========================================================================
1049 EA29                       ENTRY DrawMember
1050 EA29              DrawMember PROC 
1051 EA29
1052 EA29              theList  equ   9
1053 EA29              member   equ   theList+4
1054 EA29
1055 EA29 0B                    phd   
1056 EA2A 3B                    tsc   
1057 EA2B 5B                    tcd   
1058 EA2C                                
1059 EA2C A9 02 80              lda   #ListDrawMem             Draw the member.
1060 EA2F A6 0D                 ldx   <member                  Pass member to draw.
1061 EA31 A4 0F                 ldy   <member+2
1062 EA33
1063 EA33                       ENTRY toDefProc
1064 EA33              toDefProc      
1065 EA33 20 C0 F0              jsr   callDefProc
1066 EA36
1067 EA36 82 73 FE              brl   pop8bytes
1068 EA39
1069 EA39                       ENDP 
1070 EA39              ;==========================================================================
1071 EA39              ;
1072 EA39              ;                   SelectMember
1073 EA39              ;
1074 EA39              ;                   Select and scroll to a given member.
1075 EA39              ;
1076 EA39              ;   IN:    PUSH:LONG - pointer to member record.
1077 EA39              ;          PUSH:LONG - pointer to ListRec.
1078 EA39              ;
1079 EA39              ;  OUT:    None.
1080 EA39              ;
1081 EA39              ;==========================================================================
1082 EA39                       ENTRY SelectMember
1083 EA39              SelectMember PROC 
1084 EA39
1085 EA39              temp     equ   1
1086 EA39              theList  equ   13
1087 EA39              TheMemptr equ   theList+4
1088 EA39
1089 EA39 0B                    phd   
1090 EA3A 48                    pha   
1091 EA3B 48                    pha   
1092 EA3C 3B                    tsc   
1093 EA3D 5B                    tcd   
1094 EA3E
1095 EA3E              ;
1096 EA3E              ; --- First, deselect all currently selected members -------------------
1097 EA3E              ;
1098 EA3E 80 0D                 bra   enter1
1099 EA40 DA           lop1     phx                            Member to draw.
1100 EA41 48                    pha   
1101 EA42 D4 0F                 pei   <theList+2
1102 EA44 D4 0D                 pei   <theList
1103 EA46 A2 1C 0C 22           _DrawMember                    Draw the member in its new state.
1104 EA4D
1105 EA4D 48           enter1   pha                            Space for result.
1106 EA4E 48                    pha   
1107 EA4F D4 0F                 pei   <theList+2
1108 EA51 D4 0D                 pei   <theList
1109 EA53 A2 1C 0F 22           _ResetMember 
1110 EA5A 68                    pla   
1111 EA5B FA                    plx   
1112 EA5C D0 E2                 bne   lop1
1113 EA5E A8                    tay   
1114 EA5F D0 DF                 bne   lop1
1115 EA61
1116 EA61              ;
1117 EA61              ; --- Next, select the requested member -----------------------------------
1118 EA61              ;
1119 EA61 A5 12                 lda   <TheMemptr+1             Was a member passed?
1120 EA63 D0 03                 bne    @1
1121 EA65 82 83 00              brl    exit
1122 EA68              @1        
1123 EA68 A0 04 00              ldy   #memFlag                 Set the member's select flag.
1124 EA6B B7 11                 lda   [<TheMemptr],y
1125 EA6D 89 20 00              bit   #MEM_NEVER               not selectable ever?
1126 EA70 D0 05                 bne   @2
1127 EA72 09 80 00              ora   #MEM_SEL
1128 EA75 97 11                 sta   [<TheMemptr],y
1129 EA77              @2        
1130 EA77 D4 13                 pei   <TheMemptr+2             Pass pointer to member.
1131 EA79 D4 11                 pei   <TheMemptr
1132 EA7B D4 0F                 pei   <theList+2               Pass pointer to list.
1133 EA7D D4 0D                 pei   <theList
1134 EA7F A2 1C 0C 22           _DrawMember                    Draw the member in its new state.
1135 EA86
1136 EA86              ;
1137 EA86              ; --- Last, scroll the selected member into view --------------------------
1138 EA86              ;
1139 EA86 A0 1C 00              ldy   #ListPointer
1140 EA89 B7 0D                 lda   [<theList],y
1141 EA8B 85 01                 sta   <temp
1142 EA8D C8                    iny   
1143 EA8E B7 0D                 lda   [<theList],y
1144 EA90 85 02                 sta   <temp+1                  Start of list
1145 EA92
1146 EA92 A0 1A 00              ldy   #ListMemSize
1147 EA95 A2 00 00              ldx   #0
1148 EA98 E8           lop2     inx                            X is item #
1149 EA99 A5 01                 lda   <temp
1150 EA9B C5 11                 cmp   <TheMemptr               This the member we want to select?
1151 EA9D D0 06                 bne   next2
1152 EA9F A5 02                 lda   <temp+1
1153 EAA1 C5 12                 cmp   <TheMemptr+1
1154 EAA3 F0 0D                 beq   gotit
1155 EAA5
1156 EAA5 A5 01        next2    lda   <temp
1157 EAA7 18                    clc   
1158 EAA8 77 0D                 adc   [<theList],y             Step to next member
1159 EAAA 85 01                 sta   <temp
1160 EAAC 90 EA                 bcc   lop2
1161 EAAE E6 03                 inc   <temp+2
1162 EAB0 80 E6                 bra   lop2
1163 EAB2
1164 EAB2 DA           gotit    phx                            Pass list's new value.
1165 EAB3
1166 EAB3 48                    pha                            Space for results
1167 EAB4 A0 12 00              ldy   #ListCtl+2               Pass handle of list control.
1168 EAB7 B7 0D                 lda   [<theList],y
1169 EAB9 48                    pha   
1170 EABA 88                    dey   
1171 EABB 88                    dey   
1172 EABC B7 0D                 lda   [<theList],y
1173 EABE 48                    pha   
1174 EABF A2 10 1A 22           _GetCtlValue                   Current value
1175 EAC6 A3 03                 lda    3,s                     where I want to be
1176 EAC8 38                    sec   
1177 EAC9 E3 01                 sbc    1,s                     Desired-top
1178 EACB F0 23                 beq    no_move                 same, skip it!
1179 EACD 90 09                 bcc    move_it                 Need to change, its above the top
1180 EACF A0 0A 00              ldy    #ListView               Viewable members
1181 EAD2 F7 0D                 sbc    [<theList],y            See if showing
1182 EAD4 F0 1E                 beq    down_one                the one that is not showing
1183 EAD6 90 18                 bcc    no_move
1184 EAD8              move_it   
1185 EAD8 68                    pla                            Remove GetCtlValue from stack
1186 EAD9              move_it2  
1187 EAD9 A0 12 00              ldy   #ListCtl+2               Pass handle of list control.
1188 EADC B7 0D                 lda   [<theList],y
1189 EADE 48                    pha   
1190 EADF 88                    dey   
1191 EAE0 88                    dey   
1192 EAE1 B7 0D                 lda   [<theList],y
1193 EAE3 48                    pha   
1194 EAE4 A2 10 19 22           _SetCtlValue 
1195 EAEB
1196 EAEB 68           exit     pla   
1197 EAEC 68                    pla   
1198 EAED
1199 EAED 82 BC FD              brl   pop8bytes
1200 EAF0              no_move   
1201 EAF0 68                    pla                            Remove GetCtlValue from stack
1202 EAF1 68                    pla   
1203 EAF2 80 F7                 bra    exit
1204 EAF4              down_one  
1205 EAF4              * if the item right below the bottom, just move down one item (cheat)
1206 EAF4 FA                    plx                            GetCtlValue
1207 EAF5 68                    pla                            Toss desired target
1208 EAF6 E8                    inx                            down one
1209 EAF7 DA                    phx                            back on stack
1210 EAF8 80 DF                 bra   move_it2
1211 EAFA
1212 EAFA                       ENDP 
1213 EAFA              ;==========================================================================
1214 EAFA              ;
1215 EAFA              ;                   LockNDerefList
1216 EAFA              ;
1217 EAFA              ;                   Returns pointer to list record.
1218 EAFA              ;
1219 EAFA              ;   IN:    PUSH:LONG - Space for Result
1220 EAFA              ;          PUSH:LONG - Pointer, handle, or resourceID of list
1221 EAFA              ;          PUSH:WORD - ctl.MoreFlags (ListRefDesc)
1222 EAFA              ;
1223 EAFA              ;  OUT:    LONG - PointerToList
1224 EAFA              ;
1225 EAFA              ;==========================================================================
1226 EAFA                       ENTRY LockNDerefList
1227 EAFA              LockNDerefList PROC 
1228 EAFA
1229 EAFA              ListRefDesc equ   5
1230 EAFA              ListRef  equ   ListRefDesc+2
1231 EAFA              TheResult equ   ListRef+4
1232 EAFA
1233 EAFA 0B                    phd   
1234 EAFB 3B                    tsc   
1235 EAFC 5B                    tcd   
1236 EAFD
1237 EAFD A5 05                 lda   <ListRefDesc             ;pointer, handle, or rezID?
1238 EAFF 29 03 00              and   #$0003                   ;bits 0 and 1 determine what it is
1239 EB02 F0 32                 beq   Pointer                  ;0 = pointer
1240 EB04 3A                    dec   a
1241 EB05 F0 19                 beq   Handle
1242 EB07              ;
1243 EB07              ; TheResult a resource ID
1244 EB07              ;
1245 EB07 48                    pha                            ;long space
1246 EB08 48                    pha   
1247 EB09
1248 EB09 A9 1C 80              lda   #rListRef
1249 EB0C 48                    pha                            ;rez ID
1250 EB0D A5 09                 lda   <ListRef+2
1251 EB0F 48                    pha   
1252 EB10 A5 07                 lda   <ListRef
1253 EB12 48                    pha   
1254 EB13 A2 1E 0E 22           _LoadResource 
1255 EB1A 68                    pla                            ;get handle to member list
1256 EB1B 85 07                 sta   <ListRef
1257 EB1D 68                    pla   
1258 EB1E 85 09                 sta   <ListRef+2
1259 EB20
1260 EB20              ;
1261 EB20              ; TheResult is a handle to the member list - lock and deref it
1262 EB20              ;
1263 EB20              Handle    
1264 EB20
1265 EB20 A0 04 00              ldy   #4                       ;lock it
1266 EB23 B7 07                 lda   [ListRef],y
1267 EB25 09 00 80              ora   #$8000
1268 EB28 97 07                 sta   [ListRef],y
1269 EB2A 88                    dey                            ;deref it
1270 EB2B 88                    dey   
1271 EB2C B7 07                 lda   [ListRef],y
1272 EB2E 85 0D                 sta   <TheResult+2             ;now the result is a pointer to the 
1273 EB30 A7 07                 lda   [ListRef]
1274 EB32 85 0B                 sta   <TheResult               ;list of member pointers
1275 EB34 80 08                 bra   Alldone
1276 EB36              Pointer   
1277 EB36 A5 07                 lda   <ListRef
1278 EB38 85 0B                 sta   <TheResult
1279 EB3A A5 09                 lda   <ListRef+2
1280 EB3C 85 0D                 sta   <TheResult+2
1281 EB3E              Alldone   
1282 EB3E 2B                    pld   
1283 EB3F FA                    plx                            ;return address
1284 EB40
1285 EB40 68                    pla                            ;clear inputs
1286 EB41 68                    pla   
1287 EB42 68                    pla   
1288 EB43
1289 EB43 DA                    phx   
1290 EB44 60                    rts   
1291 EB45
1292 EB45                       ENDP 
1293 EB45              ;==========================================================================
1294 EB45              ;
1295 EB45              ;                   UnlockList
1296 EB45              ;
1297 EB45              ;                   Unlocks list record.
1298 EB45              ;
1299 EB45              ;   IN:    PUSH:LONG - Pointer, handle, or resourceID of list
1300 EB45              ;          PUSH:WORD - ctl.MoreFlags (ListRefDesc)
1301 EB45              ;
1302 EB45              ;  OUT:    NONE
1303 EB45              ;
1304 EB45              ;==========================================================================
1305 EB45                       ENTRY UnlockList
1306 EB45              UnlockList PROC EXPORT 
1307 EB45
1308 EB45              ListRefDesc equ   5
1309 EB45              ListRef  equ   ListRefDesc+2
1310 EB45
1311 EB45 0B                    phd   
1312 EB46 3B                    tsc   
1313 EB47 5B                    tcd   
1314 EB48
1315 EB48 A5 05                 lda   <ListRefDesc
1316 EB4A 29 03 00              and   #$0003                   ;bits 0 and 1 determine what it is
1317 EB4D              ;
1318 EB4D              ; If it's a pointer, we're ok 
1319 EB4D              ;
1320 EB4D F0 31                 beq   listIsPointer
1321 EB4F              ;
1322 EB4F              ; 1 means it's a handle
1323 EB4F              ;
1324 EB4F 3A                    dec   a
1325 EB50 F0 19                 beq   DoHandle
1326 EB52              ;
1327 EB52              ; It must be a resource ID
1328 EB52              ;
1329 EB52 A9 1C 80              lda   #rListRef
1330 EB55 48                    pha                            ;long space
1331 EB56 48                    pha   
1332 EB57 48                    pha   
1333 EB58 A5 09                 lda   <ListRef+2
1334 EB5A 48                    pha   
1335 EB5B A5 07                 lda   <ListRef
1336 EB5D 48                    pha   
1337 EB5E A2 1E 0E 22           _LoadResource 
1338 EB65 68                    pla                            ;get handle to member list
1339 EB66 85 07                 sta   <listref
1340 EB68 68                    pla   
1341 EB69 85 09                 sta   <listref+2
1342 EB6B              ;
1343 EB6B              ; Do Handle case
1344 EB6B              ;
1345 EB6B              DoHandle  
1346 EB6B A0 04 00              ldy   #4                       ;want to unlock it
1347 EB6E B7 07                 lda   [listref],y
1348 EB70 29 FF 7F              and   #$7FFF
1349 EB73 97 07                 sta   [listref],y
1350 EB75 88                    dey                            Derefence the list control's handle.
1351 EB76 88                    dey   
1352 EB77 B7 07                 lda   [listref],y              ;now memlist has pointer to member list
1353 EB79 AA                    tax   
1354 EB7A A7 07                 lda   [listref]
1355 EB7C 86 09                 stx   <listref+2
1356 EB7E 85 07                 sta   <listref
1357 EB80
1358 EB80              listIsPointer  
1359 EB80 2B                    pld   
1360 EB81 FA                    plx                            ;return address
1361 EB82
1362 EB82 68                    pla                            ;clear input parameters
1363 EB83 68                    pla   
1364 EB84 68                    pla   
1365 EB85 DA                    phx   
1366 EB86 60                    rts   
1367 EB87                       ENDP 
1368 EB87
1369 EB87              ;==========================================================================
1370 EB87              ;
1371 EB87              ;                   ItemNumtoPointer
1372 EB87              ;
1373 EB87              ;                   Convert item number to pointer to that item.
1374 EB87              ;
1375 EB87              ;   IN:    PUSH:LONG - Space for Result
1376 EB87              ;          PUSH:WORD - item number of member, zero returns a nil pointer, one is first item
1377 EB87              ;          PUSH:LONG - ControlHandle
1378 EB87              ;
1379 EB87              ;  OUT:    LONG - PointerToItem
1380 EB87              ;
1381 EB87              ;==========================================================================
1382 EB87                       ENTRY ItemNumtoPointer
1383 EB87              ItemNumtoPointer PROC 
1384 EB87
1385 EB87              CtlHandle equ   5
1386 EB87              CtlPtr   equ   CtlHandle
1387 EB87              ItemNum  equ   CtlHandle+4
1388 EB87              TheResult equ   ItemNum+2
1389 EB87
1390 EB87 0B                    phd   
1391 EB88 3B                    tsc   
1392 EB89 5B                    tcd   
1393 EB8A
1394 EB8A A0 02 00              ldy   #2                       ;deref ctlHandle
1395 EB8D B7 05                 lda   [CtlHandle],y
1396 EB8F AA                    tax   
1397 EB90 A7 05                 lda   [CtlHandle]
1398 EB92 86 07                 stx   <CtlPtr+2
1399 EB94 85 05                 sta   <CtlPtr
1400 EB96
1401 EB96 A0 2E 00              ldy   #CtlMemSize
1402 EB99 B7 05                 lda   [CtlPtr],y
1403 EB9B 48                    pha                            ;size of each member
1404 EB9C
1405 EB9C A0 32 00              ldy   #CtlList+2
1406 EB9F B7 05                 lda   [CtlPtr],y
1407 EBA1 85 0D                 sta   <TheResult+2
1408 EBA3 88                    dey   
1409 EBA4 88                    dey   
1410 EBA5 B7 05                 lda   [CtlPtr],y
1411 EBA7 85 0B                 sta   <TheResult               ;Member list reference
1412 EBA9
1413 EBA9              ;
1414 EBA9              ; check to see if it's a super control
1415 EBA9              ;
1416 EBA9 A0 16 00              ldy   #newCtlRecord.ctlProc+2
1417 EBAC B7 05                 lda   [CtlPtr],y
1418 EBAE 10 17                 bpl   Pointer                  ;not a super control: it's a pointer
1419 EBB0
1420 EBB0
1421 EBB0              ;
1422 EBB0              ; It's a super control. Change list reference to a pointer by calling lockNDerefList
1423 EBB0              ;
1424 EBB0 48                    pha                            ;space for result
1425 EBB1 48                    pha   
1426 EBB2 A5 0D 48 A5           PushLong <TheResult 
1427 EBB8
1428 EBB8 A0 3C 00              ldy   #newCtlRecord.ctlMoreFlags
1429 EBBB B7 05                 lda   [CtlPtr],y
1430 EBBD 48                    pha                            ;listRefDesc
1431 EBBE
1432 EBBE 20 FA EA              jsr   LockNDerefList
1433 EBC1
1434 EBC1 68                    pla   
1435 EBC2 85 0B                 sta   <TheResult
1436 EBC4 68                    pla   
1437 EBC5 85 0D                 sta   <TheResult+2
1438 EBC7
1439 EBC7              ;
1440 EBC7              ; At this point TheResult contains a pointer to the member list
1441 EBC7              ;
1442 EBC7              Pointer   
1443 EBC7 7A                    ply                            ;size of member (saved above)
1444 EBC8
1445 EBC8 A5 09                 lda   ItemNum
1446 EBCA D0 08                 bne   GoOn
1447 EBCC A9 00 00              lda   #0                       ;do entire list if pointer is zero
1448 EBCF A2 00 00              ldx   #0
1449 EBD2 80 17                 bra   End
1450 EBD4
1451 EBD4              GoOn      
1452 EBD4 3A                    dec   a                        ;convert number to index into long table
1453 EBD5 48                    pha                            ;space for result
1454 EBD6 48                    pha   
1455 EBD7 48                    pha                            ;multiply item number by 
1456 EBD8 5A                    phy                            ;size
1457 EBD9 A2 0B 09 22           _Multiply 
1458 EBE0
1459 EBE0 68                    pla                            ;high word should be zero (table can only be
1460 EBE1 7A                    ply                            ;64K bytes long)
1461 EBE2
1462 EBE2 18                    clc                            ;make pointer to item to draw
1463 EBE3 65 0B                 adc   <TheResult
1464 EBE5 AA                    tax   
1465 EBE6 A9 00 00              lda   #0
1466 EBE9 65 0D                 adc   <TheResult+2
1467 EBEB
1468 EBEB 85 0D        End      sta   <TheResult+2
1469 EBED 86 0B                 stx   <TheResult
1470 EBEF
1471 EBEF 2B                    pld   
1472 EBF0 FA                    plx                            ;return address
1473 EBF1 68                    pla                            ;clear input parameters (6 bytes)
1474 EBF2 68                    pla   
1475 EBF3 68                    pla   
1476 EBF4 DA                    phx   
1477 EBF5 60                    rts   
1478 EBF6                       ENDP 
1479 EBF6
1480 EBF6              ;==========================================================================
1481 EBF6              ;
1482 EBF6              ;                   PointertoItemNum
1483 EBF6              ;
1484 EBF6              ;                   Convert item number to pointer to that item.
1485 EBF6              ;
1486 EBF6              ; NOTE:  We should only get valid pointers at this routine since the pointer
1487 EBF6              ;        was retuned directly from the defProc and zero pointers are filtered
1488 EBF6              ;        out by the calling routine.
1489 EBF6              ;
1490 EBF6              ;   IN:    PUSH:WORD - Space for Result
1491 EBF6              ;          PUSH:LONG - Pointer to item to get number of 
1492 EBF6              ;          PUSH:LONG - ControlHandle
1493 EBF6              ;
1494 EBF6              ;  OUT:    LONG - PointerToItem
1495 EBF6              ;
1496 EBF6              ;==========================================================================
1497 EBF6                       ENTRY PointertoItemNum
1498 EBF6              PointertoItemNum PROC 
1499 EBF6
1500 EBF6              Temp     equ   3                        ;used to store deref'd ctlHandle
1501 EBF6              return   equ   Temp+4
1502 EBF6              CtlHandle equ   Return+2
1503 EBF6              CtlPtr   equ   CtlHandle
1504 EBF6              ItemNumPtr equ   CtlHandle+4
1505 EBF6              TheResult equ   ItemNumPtr+4
1506 EBF6
1507 EBF6 48                    pha                            ;temp
1508 EBF7 48                    pha   
1509 EBF8 0B                    phd   
1510 EBF9 3B                    tsc   
1511 EBFA 5B                    tcd   
1512 EBFB
1513 EBFB A0 02 00              ldy   #2                       ;deref ctlHandle
1514 EBFE B7 09                 lda   [CtlHandle],y
1515 EC00 AA                    tax   
1516 EC01 A7 09                 lda   [CtlHandle]
1517 EC03 85 09                 sta   <CtlPtr
1518 EC05 86 0B                 stx   <CtlPtr+2
1519 EC07
1520 EC07 A0 2E 00              ldy   #CtlMemSize
1521 EC0A B7 09                 lda   [CtlPtr],y
1522 EC0C 85 11                 sta   <TheResult               ;size of each member (temporary storage)
1523 EC0E              ;
1524 EC0E              ; get address of first item in the list
1525 EC0E
1526 EC0E A0 32 00              ldy   #CtlList+2
1527 EC11 B7 09                 lda   [CtlPtr],y
1528 EC13 AA                    tax   
1529 EC14 88                    dey   
1530 EC15 88                    dey   
1531 EC16 B7 09                 lda   [CtlPtr],y
1532 EC18
1533 EC18 85 03                 sta   <Temp                    ;Address of member pointer list (item 1)
1534 EC1A 86 05                 stx   <Temp+2
1535 EC1C
1536 EC1C              ;
1537 EC1C              ; See what listref (temp) is.  It's always a pointer unless its a super control
1538 EC1C              ;
1539 EC1C              ;if its old style, we can skip list handle stuff
1540 EC1C              ;
1541 EC1C
1542 EC1C A0 16 00              ldy   #newCtlRecord.ctlProc+2
1543 EC1F B7 09                 lda   [ctlptr],y
1544 EC21 10 17                 bpl   OldStyle
1545 EC23              ;
1546 EC23              ; For super controls we need to convert listref (temp) to a pointer
1547 EC23              ;
1548 EC23 48                    pha                            ;space for result
1549 EC24 48                    pha   
1550 EC25
1551 EC25 A5 05 48 A5           PushLong <Temp                 ;list reference
1552 EC2B
1553 EC2B A0 3C 00              ldy   #newCtlRecord.ctlMoreFlags
1554 EC2E B7 09                 lda   [ctlptr],y
1555 EC30 48                    pha   
1556 EC31
1557 EC31 20 FA EA              jsr   LockNDerefList
1558 EC34
1559 EC34 68                    pla   
1560 EC35 85 03                 sta   <Temp
1561 EC37 68                    pla   
1562 EC38 85 05                 sta   <Temp+2
1563 EC3A
1564 EC3A              OldStyle  
1565 EC3A A5 0D                 lda   <ItemNumPtr
1566 EC3C 38                    sec   
1567 EC3D E5 03                 sbc   <Temp                    ;don't need MSB.  Will always be 0
1568 EC3F
1569 EC3F              ; 
1570 EC3F              ; A reg contains offset to item in the list.  We divide this by the length of
1571 EC3F              ; each pointer field (in TheResult) to get the item number
1572 EC3F              ;
1573 EC3F 48                    pha                            ;space for remainder
1574 EC40 48                    pha                            ;space for quotient
1575 EC41
1576 EC41 48                    pha                            ;divide offset by
1577 EC42
1578 EC42 A5 11                 lda   <TheResult               ;length of each field
1579 EC44 48                    pha   
1580 EC45 A2 0B 0B 22           _UDivide 
1581 EC4C
1582 EC4C 68                    pla                            ;quotient (item number -1)
1583 EC4D FA                    plx                            ;remainder (should be zero, we don't want it)
1584 EC4E 1A                    inc   a                        ;convert to item number
1585 EC4F
1586 EC4F 85 11        Foundit  sta   <TheResult
1587 EC51
1588 EC51 2B                    pld   
1589 EC52
1590 EC52 68                    pla                            ;clear temp work area off stack
1591 EC53 68                    pla   
1592 EC54
1593 EC54 FA                    plx                            ;return address
1594 EC55
1595 EC55 68                    pla                            ;clear input parameters (8 bytes)
1596 EC56 68                    pla   
1597 EC57 68                    pla   
1598 EC58 68                    pla   
1599 EC59
1600 EC59 DA                    phx   
1601 EC5A 60                    rts   
1602 EC5B
1603 EC5B                       ENDP 
1604 EC5B
1605 EC5B              ;==========================================================================
1606 EC5B              ;
1607 EC5B              ;                   DrawMember2
1608 EC5B              ;
1609 EC5B              ;                   Redraw a member.
1610 EC5B              ;
1611 EC5B              ;   IN:    PUSH:WORD - item number of member to draw, zero for whole list.
1612 EC5B              ;          PUSH:LONG - ControlHandle
1613 EC5B              ;
1614 EC5B              ;  OUT:    None.
1615 EC5B              ;
1616 EC5B              ;==========================================================================
1617 EC5B                       ENTRY DrawMember2
1618 EC5B              DrawMember2 PROC 
1619 EC5B
1620 EC5B              CtlHandle equ   9
1621 EC5B              ItemNum  equ   CtlHandle+4
1622 EC5B
1623 EC5B 0B                    phd   
1624 EC5C 3B                    tsc   
1625 EC5D 5B                    tcd   
1626 EC5E
1627 EC5E 48                    pha                            ;long space for pointer result
1628 EC5F 48                    pha   
1629 EC60 A5 0D                 lda   <ItemNum
1630 EC62 48                    pha   
1631 EC63 A5 0B 48 A5           PushLong <CtlHandle 
1632 EC69 20 87 EB              jsr   ItemNumtoPointer
1633 EC6C FA                    plx                            ;pointer to item
1634 EC6D 7A                    ply   
1635 EC6E A9 02 80              lda   #ListDrawMem
1636 EC71 20 D7 F0              jsr   CallDefProc2
1637 EC74 A2 06 00              ldx   #6
1638 EC77 82 35 FC              brl   pop
1639 EC7A
1640 EC7A                       ENDP 
1641 EC7A
1642 EC7A              ;==========================================================================
1643 EC7A              ;
1644 EC7A              ;                   NextMember2
1645 EC7A              ;
1646 EC7A              ;                   Find next selected member.
1647 EC7A              ;
1648 EC7A              ;   IN:    PUSH:WORD - Result Space (for number of next selected member)    
1649 EC7A              ;          PUSH:WORD - Number of member to start at, zero or one for first member.
1650 EC7A              ;          PUSH:LONG - Control Handle
1651 EC7A              ;
1652 EC7A              ;  OUT:    WORD - next selected member in list, zero if no more.
1653 EC7A              ;
1654 EC7A              ;==========================================================================
1655 EC7A                       ENTRY NextMember2
1656 EC7A              NextMember2 PROC 
1657 EC7A
1658 EC7A              CtlHandle equ   9
1659 EC7A              ItemNum  equ   CtlHandle+4
1660 EC7A              TheResult equ   ItemNum+2
1661 EC7A
1662 EC7A 0B                    phd   
1663 EC7B 3B                    tsc   
1664 EC7C 5B                    tcd   
1665 EC7D
1666 EC7D 48                    pha                            ;long space for pointer result
1667 EC7E 48                    pha   
1668 EC7F A5 0D                 lda   <ItemNum
1669 EC81 48                    pha   
1670 EC82 A5 0B 48 A5           PushLong <CtlHandle 
1671 EC88 20 87 EB              jsr   ItemNumtoPointer
1672 EC8B FA                    plx                            ;pointer to item
1673 EC8C 7A                    ply   
1674 EC8D
1675 EC8D A9 00 80              lda   #ListFirst               Get first selected member.
1676 EC90 20 D7 F0              jsr   callDefProc2
1677 EC93
1678 EC93 86 0F                 stx   <ItemNum+2               ;At this point ItemNum is in pointer form
1679 EC95 85 0D                 sta   <ItemNum                 ;Since we don't have a result yet it's ok to spill
1680 EC97                                                      ;into TheResult (ItemNum+2) field.
1681 EC97 05 0F                 ora   <ItemNum+2               Was a selected member found?
1682 EC99 F0 20                 beq   exit                     If not, all done.
1683 EC9B
1684 EC9B A0 04 00              ldy   #memFlag                 The defProc deselected the member,
1685 EC9E B7 0D                 lda   [<ItemNum],y             this call wants it left alone.
1686 ECA0 89 20 00              bit   #MEM_NEVER
1687 ECA3 D0 05                 bne   @1
1688 ECA5 09 80 00              ora   #MEM_SEL
1689 ECA8 97 0D                 sta   [<ItemNum],y
1690 ECAA              @1        
1691 ECAA              ;
1692 ECAA              ; Convert pointer (long) to item number (word)
1693 ECAA              ;
1694 ECAA 48                    pha                            ;space for result
1695 ECAB DA                    phx                            ;high byte of pointer
1696 ECAC A5 0D                 lda   <ItemNum                 ;low byte of pointer
1697 ECAE 48                    pha   
1698 ECAF A5 0B 48 A5           PushLong <CtlHandle 
1699 ECB5 20 F6 EB              jsr   PointerToItemNum
1700 ECB8 68                    pla   
1701 ECB9 85 0F                 sta   <TheResult
1702 ECBB
1703 ECBB A2 06 00     exit     ldx   #6
1704 ECBE 82 EE FB              brl   pop
1705 ECC1
1706 ECC1                       ENDP 
1707 ECC1
1708 ECC1              ;
1709 ECC1              ;
1710 ECC1              ;==========================================================================
1711 ECC1              ;
1712 ECC1              ;                   ResetMember2
1713 ECC1              ;
1714 ECC1              ;                   Find next selected member and reset its selected member.
1715 ECC1              ;
1716 ECC1              ;   IN:    PUSH:LONG - pointer to Control Handle
1717 ECC1              ;
1718 ECC1              ;  OUT:    WORD - next selected member in list, zero if no more.
1719 ECC1              ;
1720 ECC1              ;==========================================================================
1721 ECC1                       ENTRY ResetMember2
1722 ECC1              ResetMember2 PROC 
1723 ECC1
1724 ECC1              CtlHandle equ   9
1725 ECC1              TheResult equ   CtlHandle+4
1726 ECC1
1727 ECC1 0B                    phd   
1728 ECC2 3B                    tsc   
1729 ECC3 5B                    tcd   
1730 ECC4
1731 ECC4 A2 00 00              ldx   #0                       Start at top of list.
1732 ECC7 9B                    txy   
1733 ECC8
1734 ECC8 A9 00 80              lda   #ListFirst               Get first selected member.
1735 ECCB 20 D7 F0              jsr   callDefProc2
1736 ECCE
1737 ECCE C9 00 00              cmp   #0                       ;a and x contain member pointer
1738 ECD1 D0 09                 bne   cont                     ;If zero, all done.
1739 ECD3 E0 00 00              cpx   #0
1740 ECD6 D0 04                 bne   cont
1741 ECD8 64 0D                 stz   <TheResult               ;zero if no member selected
1742 ECDA 80 0F                 bra   exit
1743 ECDC
1744 ECDC              ;
1745 ECDC              ; Convert pointer (long) to item number (word)
1746 ECDC              ;
1747 ECDC              cont      
1748 ECDC 48                    pha                            ;space for result
1749 ECDD DA                    phx                            ;high byte of pointer
1750 ECDE 48                    pha   
1751 ECDF A5 0B 48 A5           PushLong <CtlHandle 
1752 ECE5 20 F6 EB              jsr   PointerToItemNum
1753 ECE8 68                    pla   
1754 ECE9 85 0D                 sta   <TheResult
1755 ECEB
1756 ECEB A2 04 00     exit     ldx   #4
1757 ECEE 82 BE FB              brl   pop
1758 ECF1
1759 ECF1                       ENDP 
1760 ECF1
1761 ECF1
1762 ECF1              ;==========================================================================
1763 ECF1              ;
1764 ECF1              ;                   SelectMember2
1765 ECF1              ;
1766 ECF1              ;                   Select and scroll to a given member.
1767 ECF1              ;
1768 ECF1              ;   IN:    PUSH:WORD - Item Number
1769 ECF1              ;          PUSH:LONG - control Handle
1770 ECF1              ;
1771 ECF1              ;  OUT:    None.
1772 ECF1              ;
1773 ECF1              ;==========================================================================
1774 ECF1                       ENTRY SelectMember2
1775 ECF1              SelectMember2 PROC 
1776 ECF1
1777 ECF1              temp     equ   1
1778 ECF1              CtlHandle equ   13
1779 ECF1              ItemNum  equ   CtlHandle+4
1780 ECF1
1781 ECF1 0B                    phd   
1782 ECF2 48                    pha   
1783 ECF3 48                    pha   
1784 ECF4 3B                    tsc   
1785 ECF5 5B                    tcd   
1786 ECF6
1787 ECF6              ;
1788 ECF6              ; --- First, deselect all currently selected members -------------------
1789 ECF6              ;
1790 ECF6 80 0C                 bra   enter1
1791 ECF8              lop1      
1792 ECF8 48                    pha                            ;Member to draw.
1793 ECF9 D4 0F                 pei   <CtlHandle+2
1794 ECFB D4 0D                 pei   <CtlHandle
1795 ECFD A2 1C 11 22           _DrawMember2                   Draw the member in its new state.
1796 ED04
1797 ED04 48           enter1   pha                            Space for result.
1798 ED05 48                    pha   
1799 ED06 D4 0F                 pei   <CtlHandle+2
1800 ED08 D4 0D                 pei   <CtlHandle
1801 ED0A A2 1C 13 22           _ResetMember2 
1802 ED11
1803 ED11 68                    pla   
1804 ED12 FA                    plx   
1805 ED13 C9 00 00              cmp   #0
1806 ED16 D0 E0                 bne   lop1
1807 ED18
1808 ED18              ;
1809 ED18              ; --- Next, select the requested member -----------------------------------
1810 ED18              ;
1811 ED18 A5 11                 lda   <ItemNum                 ;Was a member passed?
1812 ED1A D0 03                 bne    @1
1813 ED1C 82 69 00              brl    exit
1814 ED1F              @1        
1815 ED1F 48                    pha                            ;long space for pointer result
1816 ED20 48                    pha   
1817 ED21
1818 ED21 48                    pha                            ;itemNum
1819 ED22 A5 0F 48 A5           PushLong <CtlHandle 
1820 ED28 20 87 EB              jsr   ItemNumtoPointer
1821 ED2B 68                    pla                            ;pointer to item
1822 ED2C 85 01                 sta   <temp
1823 ED2E 68                    pla   
1824 ED2F 85 03                 sta   <temp+2
1825 ED31
1826 ED31 A0 04 00              ldy   #memFlag                 Set the member's select flag.
1827 ED34 B7 01                 lda   [<temp],y
1828 ED36 89 20 00              bit   #MEM_NEVER               not selectable ever?
1829 ED39 D0 05                 bne   @2
1830 ED3B 09 80 00              ora   #MEM_SEL
1831 ED3E 97 01                 sta   [<temp],y
1832 ED40              @2        
1833 ED40 A5 11                 lda   <ItemNum
1834 ED42 48                    pha   
1835 ED43 D4 0F                 pei   <CtlHandle+2             ;Pass handle to list control.
1836 ED45 D4 0D                 pei   <CtlHandle
1837 ED47 A2 1C 11 22           _DrawMember2                   Draw the member in its new state.
1838 ED4E
1839 ED4E              ;
1840 ED4E              ; --- Last, scroll the selected member into view --------------------------
1841 ED4E              ;
1842 ED4E A6 11                 ldx   <ItemNum
1843 ED50 DA                    phx                            Pass list's new value.
1844 ED51
1845 ED51 48                    pha                            Space for results
1846 ED52 D4 0F                 pei   <CtlHandle+2             ;Pass handle of list control
1847 ED54 D4 0D                 pei   <CtlHandle
1848 ED56 A2 10 1A 22           _GetCtlValue                   Current value
1849 ED5D A3 03                 lda    3,s                     ;new value (x above)
1850 ED5F 38                    sec   
1851 ED60 E3 01                 sbc    1,s                     Desired-top
1852 ED62 F0 2C                 beq    no_move                 same, skip it!
1853 ED64 90 16                 bcc    move_it                 Need to change, its above the top
1854 ED66              ;
1855 ED66              ; We need to deref the CtlHandle to get to the list view field
1856 ED66              ;
1857 ED66 48                    pha                            ;SAVE new value - current value = desired top
1858 ED67
1859 ED67 A7 0D                 lda   [CtlHandle]
1860 ED69 85 01                 sta   <Temp
1861 ED6B A0 02 00              ldy   #2
1862 ED6E B7 0D                 lda   [CtlHandle],y
1863 ED70 85 03                 sta   <Temp+2
1864 ED72              ;
1865 ED72              ; NOTE:  This code was transliterated. 
1866 ED72              ;
1867 ED72 68                    pla                            ;get desired top
1868 ED73 A0 1C 00              ldy    #ctlData                ;offset to listView (page 11-9 Toolbox)
1869 ED76 F7 01                 sbc    [<Temp],y               See if showing
1870 ED78 F0 1A                 beq    down_one                the one that is not showing
1871 ED7A 90 14                 bcc    no_move
1872 ED7C              move_it   
1873 ED7C 68                    pla                            Remove GetCtlValue from stack
1874 ED7D              move_it2  
1875 ED7D                                                      ;Top of stack contains new value
1876 ED7D D4 0F                 pei   <CtlHandle+2             ;Pass handle of list control
1877 ED7F D4 0D                 pei   <CtlHandle
1878 ED81 A2 10 19 22           _SetCtlValue 
1879 ED88
1880 ED88 68           exit     pla   
1881 ED89 68                    pla   
1882 ED8A
1883 ED8A A2 06 00              ldx   #6
1884 ED8D 82 1F FB              brl   pop
1885 ED90              no_move   
1886 ED90 68                    pla                            Remove GetCtlValue from stack
1887 ED91 68                    pla   
1888 ED92 80 F4                 bra    exit
1889 ED94              down_one  
1890 ED94              * if the item right below the bottom, just move down one item (cheat)
1891 ED94 FA                    plx                            GetCtlValue
1892 ED95 68                    pla                            Toss desired target
1893 ED96 E8                    inx                            down one
1894 ED97 DA                    phx                            back on stack
1895 ED98 80 E3                 bra   move_it2
1896 ED9A
1897 ED9A                       ENDP 
1898 ED9A
1899 ED9A              ;==========================================================================
1900 ED9A              ;
1901 ED9A              ;                   NewList2
1902 ED9A              ;
1903 ED9A              ;                   Put a new list in a list control.
1904 ED9A              ;
1905 ED9A              ;   IN:             PUSH:LONG - DrawPtrR
1906 ED9A              ;                   PUSH:WORD - ListStartR
1907 ED9A              ;                   PUSH:LONG - ListRefR
1908 ED9A              ;                   PUSH:WORD - ListRefDiscriptorR
1909 ED9A              ;                   PUSH:WORD - ListSizeR
1910 ED9A              ;                   PUSH:LONG - CtlHandle
1911 ED9A              ;
1912 ED9A              ;  OUT:    None.
1913 ED9A              ;
1914 ED9A              ; Change History
1915 ED9A              ;
1916 ED9A              ; 4 Jan 89          Steven Glass and Konstantin Othmer
1917 ED9A              ;
1918 ED9A              ; Use $FFFF to indicate that a field should not change (rather than 
1919 ED9A              ; zero) since zero can be valid entry for some fields.
1920 ED9A              ;
1921 ED9A              ; Use correct direct page and direct page equates for invalidating
1922 ED9A              ; the rectangles of the control.
1923 ED9A              ;
1924 ED9A              ; Fixed call to GetVisStatus to pass handle in correctly.
1925 ED9A              ;
1926 ED9A              ; Added code to invalidate the rect of the scroll bar too.
1927 ED9A              ;
1928 ED9A              ; 18 May 89         Steven Glass
1929 ED9A              ;
1930 ED9A              ; Added code to look at current ListStart if list start is not
1931 ED9A              ; supposed to change.
1932 ED9A              ;
1933 ED9A              ;==========================================================================
1934 ED9A                       ENTRY NewList2
1935 ED9A              NewList2 PROC 
1936 ED9A              CwrkPtr  equ   1
1937 ED9A              CtlPtr   equ   CwrkPtr+4
1938 ED9A              dreg     equ   CtlPtr+4
1939 ED9A              rtl1     equ   dreg+2
1940 ED9A              rtl2     equ   rtl1+3
1941 ED9A              CtlHandle equ   rtl2+3
1942 ED9A              ListSizeR equ   CtlHandle+4
1943 ED9A              ListRefDiscriptorR equ   ListSizeR+2
1944 ED9A              ListRefR equ   ListRefDiscriptorR+2
1945 ED9A              ListStartR equ   ListRefR+4
1946 ED9A              DrawPtrR equ   ListStartR+2
1947 ED9A
1948 ED9A 0B                    phd   
1949 ED9B 48                    pha                            ;space for CtlPtr
1950 ED9C 48                    pha   
1951 ED9D
1952 ED9D 48                    pha                            ;space for CworkPtr
1953 ED9E 48                    pha   
1954 ED9F
1955 ED9F 3B                    tsc   
1956 EDA0 5B                    tcd   
1957 EDA1              ;
1958 EDA1              ; Deref control handle
1959 EDA1              ;
1960 EDA1 A0 02 00              ldy   #2
1961 EDA4 B7 11                 lda   [CtlHandle],y
1962 EDA6 85 07                 sta   <CtlPtr+2
1963 EDA8 A7 11                 lda   [CtlHandle]
1964 EDAA 85 05                 sta   <CtlPtr
1965 EDAC
1966 EDAC A5 11                 lda   CtlHandle
1967 EDAE A6 13                 ldx   CtlHandle+2
1968 EDB0 20 E1 EE              jsr   GetVisStatus
1969 EDB3
1970 EDB3 48                    pha                            ;0 = visible, 80 = invisible
1971 EDB4 C9 00 00              cmp   #0
1972 EDB7
1973 EDB7 D0 07                 bne   NoFlip
1974 EDB9 A5 11                 lda   <CtlHandle               Pass control Handle.
1975 EDBB A6 13                 ldx   <CtlHandle+2
1976 EDBD 20 A5 EE              jsr   flipVis                  Make list control invisible.
1977 EDC0
1978 EDC0              ;
1979 EDC0              ; Do ListNew2 here (instead of in defProc) because we have all the parameters available
1980 EDC0              ;
1981 EDC0              NoFlip    
1982 EDC0              ;
1983 EDC0              ; Set the list size in the list control and the associated scroll bar.
1984 EDC0              ;
1985 EDC0 A5 15                 lda   <ListSizeR
1986 EDC2 C9 FF FF              cmp   #$FFFF
1987 EDC5 F0 1F                 beq   GoOn1                    ;branch if no change
1988 EDC7 48                    pha                            ;new data size
1989 EDC8 A0 1E 00              ldy   #CtlData+2               ;set list controls new data size
1990 EDCB 97 05                 sta   [CtlPtr],y
1991 EDCD F4 FF FF              pea   $FFFF                    ;same view size
1992 EDD0
1993 EDD0 A0 36 00              ldy   #CtlListBar+2            Pass handle of scroll bar.
1994 EDD3 B7 05                 lda   [CtlPtr],y
1995 EDD5 85 03                 sta   <cwrkptr+2
1996 EDD7 48                    pha   
1997 EDD8 88                    dey   
1998 EDD9 88                    dey   
1999 EDDA B7 05                 lda   [CtlPtr],y
2000 EDDC 85 01                 sta   <cwrkptr
2001 EDDE 48                    pha   
2002 EDDF A2 10 1B 22           _SetCtlParams 
2003 EDE6
2004 EDE6
2005 EDE6              GoOn1     
2006 EDE6              ;
2007 EDE6              ; Set the first item viewed in the list control and the 
2008 EDE6              ; associated scroll bar.
2009 EDE6              ;
2010 EDE6 A5 1D                 lda   <ListStartR
2011 EDE8 C9 FF FF              cmp   #$FFFF
2012 EDEB F0 0C                 beq   GoOn2
2013 EDED
2014 EDED 48           store1   pha   
2015 EDEE D4 13                 pei   <ctlHandle+2             Pass handle of scroll bar.
2016 EDF0 D4 11                 pei   <ctlHandle
2017 EDF2 A2 10 19 22           _SetCtlValue 
2018 EDF9              GoOn2     
2019 EDF9
2020 EDF9              ;
2021 EDF9              ; Set the ListRef in the list control.  Scroll bar untouched.
2022 EDF9              ;
2023 EDF9 A6 1B                 ldx   <ListRefR+2
2024 EDFB E0 FF FF              cpx   #$FFFF
2025 EDFE F0 18                 beq   GoOn3
2026 EE00 A5 19                 lda   <ListRefR
2027 EE02
2028 EE02 A0 30 00              ldy   #CtlList
2029 EE05 97 05                 sta   [CtlPtr],y
2030 EE07 C8                    iny   
2031 EE08 C8                    iny   
2032 EE09 8A                    txa   
2033 EE0A 97 05                 sta   [CtlPtr],y
2034 EE0C              ;
2035 EE0C              ; Update MoreFlags
2036 EE0C              ;
2037 EE0C A0 3C 00              ldy   #newCtlRecord.ctlMoreFlags
2038 EE0F B7 05                 lda   [ctlptr],y
2039 EE11 29 FC FF              and   #$FFFC
2040 EE14 05 17                 ora   <ListRefDiscriptorR
2041 EE16 97 05                 sta   [ctlptr],y
2042 EE18
2043 EE18              GoOn3                                   ;update drawptr
2044 EE18 A6 21                 ldx   <DrawPtrR+2
2045 EE1A C9 FF FF              cmp   #$FFFF                   ;BUG in ROM 03 - should be CPX
2046 EE1D F0 0C                 beq   GoOn4
2047 EE1F A5 1F                 lda   <DrawPtrR
2048 EE21
2049 EE21 A0 28 00              ldy   #ctlMemDraw
2050 EE24 97 05                 sta   [CtlPtr],y
2051 EE26 C8                    iny   
2052 EE27 C8                    iny   
2053 EE28 8A                    txa   
2054 EE29 97 05                 sta   [CtlPtr],y
2055 EE2B
2056 EE2B              GoOn4     
2057 EE2B 68                    pla                            ;VisStatus
2058 EE2C D0 07                 bne   NoFlip1
2059 EE2E
2060 EE2E A5 11                 lda   <CtlHandle               Pass control Handle.
2061 EE30 A6 13                 ldx   <CtlHandle+2
2062 EE32 20 A5 EE              jsr   flipVis                  Make list control visible.
2063 EE35
2064 EE35              NoFlip1   
2065 EE35              ;
2066 EE35              ; Make control region invalid instead of redrawing the control
2067 EE35              ;
2068 EE35 48                    pha   
2069 EE36 48                    pha                            ;space for result
2070 EE37 A2 04 1C 22           _GetPort 
2071 EE3E
2072 EE3E A0 06 00              ldy   #CtlOwner+2
2073 EE41 B7 05                 lda   [CtlPtr],y
2074 EE43 48                    pha   
2075 EE44 A0 04 00              ldy   #CtlOwner
2076 EE47 B7 05                 lda   [CtlPtr],y
2077 EE49 48                    pha   
2078 EE4A A2 04 1B 22           _SetPort 
2079 EE51
2080 EE51 A5 05                 lda   CtlPtr
2081 EE53 18                    clc   
2082 EE54 69 08 00              adc   #CtlRect
2083 EE57 AA                    tax   
2084 EE58 A5 07                 lda   CtlPtr+2
2085 EE5A 69 00 00              adc   #0
2086 EE5D 48                    pha                            ;pointer to rect. data structure
2087 EE5E DA                    phx   
2088 EE5F A2 0E 3A 22           _InvalRect 
2089 EE66
2090 EE66 A0 36 00              ldy   #CtlListBar+2            Pass handle of scroll bar.
2091 EE69 B7 05                 lda   [CtlPtr],y
2092 EE6B 85 03                 sta   <cwrkptr+2
2093 EE6D 88                    dey   
2094 EE6E 88                    dey   
2095 EE6F B7 05                 lda   [CtlPtr],y
2096 EE71 85 01                 sta   <cwrkptr
2097 EE73 A0 02 00              ldy   #2
2098 EE76 B7 01                 lda   [<cwrkptr],y
2099 EE78 AA                    tax   
2100 EE79 A7 01                 lda   [<cwrkptr]
2101 EE7B 85 01                 sta   <cwrkptr
2102 EE7D 86 03                 stx   <cwrkptr+2
2103 EE7F
2104 EE7F A5 01                 lda   <cwrkptr
2105 EE81 18                    clc   
2106 EE82 69 08 00              adc   #CtlRect
2107 EE85 AA                    tax   
2108 EE86 A5 03                 lda   <cwrkptr+2
2109 EE88 69 00 00              adc   #0
2110 EE8B 48                    pha                            ;pointer to rect. data structure
2111 EE8C DA                    phx   
2112 EE8D A2 0E 3A 22           _InvalRect 
2113 EE94
2114 EE94
2115 EE94 A2 04 1B 22           _SetPort                       ;put the port back
2116 EE9B
2117 EE9B
2118 EE9B 68                    pla                            ;remove work area from stack
2119 EE9C 68                    pla                            ;(four words)
2120 EE9D 68                    pla   
2121 EE9E 68                    pla   
2122 EE9F
2123 EE9F A2 12 00              ldx   #18
2124 EEA2 82 0A FA              brl   pop
2125 EEA5              ;
2126 EEA5              ;---------------------------------------------------------------
2127 EEA5              ;          Flip vis state of list and scroll bar.
2128 EEA5              ;100------------------------------------------------------------
2129 EEA5              ;
2130 EEA5              temp     equ   1
2131 EEA5              ;
2132 EEA5 0B           FlipVis  phd   
2133 EEA6 DA                    phx                            ;Control Handle
2134 EEA7 48                    pha   
2135 EEA8 3B                    tsc   
2136 EEA9 5B                    tcd   
2137 EEAA
2138 EEAA A5 01                 lda   <temp
2139 EEAC A6 03                 ldx   <temp+2
2140 EEAE
2141 EEAE 20 C6 EE              jsr   flipit                   ;a and x contain CtlHandle
2142 EEB1
2143 EEB1 A0 36 00              ldy   #CtlListBar+2            Flip vis state of scroll bar.
2144 EEB4 B7 01                 lda   [<temp],y
2145 EEB6 AA                    tax   
2146 EEB7 88                    dey   
2147 EEB8 88                    dey   
2148 EEB9 B7 01                 lda   [<temp],y
2149 EEBB DA                    phx                            Save scroll bar handle.
2150 EEBC 48                    pha   
2151 EEBD 20 C6 EE              jsr   flipit
2152 EEC0 68                    pla                            Return handle of scroll bar.
2153 EEC1 FA                    plx   
2154 EEC2
2155 EEC2 7A                    ply   
2156 EEC3 7A                    ply   
2157 EEC4 2B                    pld   
2158 EEC5 60                    rts   
2159 EEC6
2160 EEC6 85 01        flipit   sta   <temp                    Store control handle.
2161 EEC8 86 03                 stx   <temp+2
2162 EECA
2163 EECA A0 02 00              ldy   #2                       Dereference control.
2164 EECD B7 01                 lda   [<temp],y
2165 EECF A8                    tay   
2166 EED0 A7 01                 lda   [<temp]
2167 EED2 85 01                 sta   <temp
2168 EED4 84 03                 sty   <temp+2
2169 EED6
2170 EED6 A0 10 00              ldy   #CtlFlag                 Flip vis state.
2171 EED9 B7 01                 lda   [<temp],y
2172 EEDB 49 80 00              eor   #$0080
2173 EEDE 97 01                 sta   [<temp],y
2174 EEE0 60                    rts   
2175 EEE1
2176 EEE1              ;
2177 EEE1              ;---------------------------------------------------------------
2178 EEE1              ;          Get vis status of list.
2179 EEE1              ;100------------------------------------------------------------
2180 EEE1              ;
2181 EEE1              temp1    equ   1
2182 EEE1              ;
2183 EEE1 0B           GetVisStatus phd   
2184 EEE2 DA                    phx                            ;Control Handle
2185 EEE3 48                    pha   
2186 EEE4 3B                    tsc   
2187 EEE5 5B                    tcd   
2188 EEE6
2189 EEE6 A0 02 00              ldy   #2                       Dereference control.
2190 EEE9 B7 01                 lda   [<temp1],y
2191 EEEB A8                    tay   
2192 EEEC A7 01                 lda   [<temp1]
2193 EEEE 85 01                 sta   <temp1
2194 EEF0 84 03                 sty   <temp1+2
2195 EEF2
2196 EEF2 A0 10 00              ldy   #CtlFlag                 Flip vis state.
2197 EEF5 B7 01                 lda   [<temp1],y
2198 EEF7
2199 EEF7 29 80 00              and   #$0080                   ;zero is visible
2200 EEFA
2201 EEFA 7A                    ply   
2202 EEFB 7A                    ply   
2203 EEFC 2B                    pld   
2204 EEFD 60                    rts   
2205 EEFE
2206 EEFE                       ENDP 
2207 EEFE
2208 EEFE
2209 EEFE              ;==========================================================================
2210 EEFE              ;
2211 EEFE              ;                   SortList2
2212 EEFE              ;
2213 EEFE              ;                   Alphabetize list.
2214 EEFE              ;
2215 EEFE              ;   IN:    PUSH:LONG - address of routine to call to compare strings.
2216 EEFE              ;          PUSH:LONG - Control Handle
2217 EEFE              ;
2218 EEFE              ;  OUT:    None.
2219 EEFE              ;==========================================================================
2220 EEFE                       ENTRY SortList2
2221 EEFE              SortList2 PROC 
2222 EEFE
2223 EEFE                       import upcase8 
2224 EEFE
2225 EEFE              memSize  equ   1
2226 EEFE              stringType equ   memSize+2
2227 EEFE              counter  equ   stringType+2
2228 EEFE              save     equ   counter+2
2229 EEFE              blit     equ   save+4
2230 EEFE              strg1    equ   blit+4
2231 EEFE              strg2    equ   strg1+4
2232 EEFE              listptr  equ   strg2+4
2233 EEFE              current  equ   listptr+4
2234 EEFE              gopher   equ   current+2
2235 EEFE              CtlPointer equ   gopher+4
2236 EEFE              worksize equ   CtlPointer+4
2237 EEFE
2238 EEFE              CtlHandle equ   worksize+9
2239 EEFE              UseCompare equ   CtlHandle+4
2240 EEFE
2241 EEFE              ACC      equ   $20
2242 EEFE              XY       equ   $10
2243 EEFE
2244 EEFE
2245 EEFE 0B                    phd                            Save orginal direct page.
2246 EEFF
2247 EEFF 3B                    tsc   
2248 EF00 38                    sec   
2249 EF01 E9 25 00              sbc   #worksize
2250 EF04 1B                    tcs   
2251 EF05 5B                    tcd   
2252 EF06              ;
2253 EF06              ; Handle to pointer
2254 EF06              ;
2255 EF06 A7 2E                 lda   [CtlHandle]
2256 EF08 85 21                 sta   <CtlPointer
2257 EF0A A0 02 00              ldy   #2
2258 EF0D B7 2E                 lda   [CtlHandle],y
2259 EF0F 85 23                 sta   <CtlPointer+2
2260 EF11
2261 EF11              ;
2262 EF11              ; --- Bubble sort member list -----------------------------------------
2263 EF11              ;
2264 EF11 A0 1E 00              ldy   #CtlData+2               ;ListSize
2265 EF14 B7 21                 lda   [<CtlPointer],y
2266 EF16 F0 03                 beq   toexit                   There must be at least two members.
2267 EF18 3A                    dec   a
2268 EF19 D0 03                 bne   store3                   There must be at least two members.
2269 EF1B 82 B6 00     toexit   brl   exit
2270 EF1E 85 05        store3   sta   <counter                 Total number of members less one.
2271 EF20
2272 EF20 A0 2E 00              ldy   #ctlMemSize              Get size of member record.
2273 EF23 B7 21                 lda   [<CtlPointer],y
2274 EF25 85 01                 sta   <memSize
2275 EF27
2276 EF27 A0 10 00              ldy   #CtlFlag                 ;ListType
2277 EF2A B7 21                 lda   [<CtlPointer],y
2278 EF2C 29 01 00              and   #1
2279 EF2F 85 03                 sta   <stringType              0 = pascal strings, 1 = null terminated.
2280 EF31
2281 EF31              ;
2282 EF31              ; Get pointer to member list
2283 EF31              ;
2284 EF31 48                    pha                            ;space for result
2285 EF32 48                    pha   
2286 EF33 A0 32 00              ldy   #CtlList+2               ; push listref
2287 EF36 B7 21                 lda   [<CtlPointer],y
2288 EF38 48                    pha   
2289 EF39 88                    dey   
2290 EF3A 88                    dey   
2291 EF3B B7 21                 lda   [<CtlPointer],y
2292 EF3D 48                    pha   
2293 EF3E
2294 EF3E A0 3C 00              ldy   #newCtlRecord.ctlMoreFlags
2295 EF41 B7 21                 lda   [<ctlpointer],y
2296 EF43 48                    pha   
2297 EF44
2298 EF44 20 FA EA              jsr   LockNDerefList
2299 EF47
2300 EF47 68                    pla   
2301 EF48 85 17                 sta   <listptr
2302 EF4A A8                    tay   
2303 EF4B 68                    pla   
2304 EF4C 85 19                 sta   <listptr+2
2305 EF4E AA                    tax   
2306 EF4F 98                    tya   
2307 EF50              ;
2308 EF50              ; pointer is in listptr now
2309 EF50              ;
2310 EF50 38                    sec                            Set pointer for easy block moves.
2311 EF51 E5 01                 sbc   <memSize
2312 EF53 B0 01                 bcs   store2
2313 EF55 CA                    dex   
2314 EF56 85 0B        store2   sta   <blit
2315 EF58 86 0D                 stx   <blit+2
2316 EF5A
2317 EF5A 64 1D                 stz   <gopher                  Gopher is always at least one behind.
2318 EF5C 64 1B                 stz   <current
2319 EF5E 80 07                 bra   enter1
2320 EF60
2321 EF60 A5 1D        lop1     lda   <gopher                  Next gopher index.
2322 EF62 18                    clc   
2323 EF63 65 01                 adc   <memSize
2324 EF65 85 1D                 sta   <gopher
2325 EF67
2326 EF67 A5 1B        enter1   lda   <current                 Next current index.
2327 EF69 18                    clc   
2328 EF6A 65 01                 adc   <memSize
2329 EF6C 85 1B                 sta   <current
2330 EF6E
2331 EF6E 20 DD EF              jsr   compare                  Is 'current' >= 'gopher'?
2332 EF71 B0 49                 bcs   next1
2333 EF73
2334 EF73              ;
2335 EF73              ; ------ Float 'current' to it's proper level -----------------------------
2336 EF73              ;
2337 EF73 A5 1D        lop2     lda   <gopher                  Backup gopher.
2338 EF75 F0 11                 beq   insert                   At top of list?
2339 EF77 38                    sec   
2340 EF78 E5 01                 sbc   <memSize
2341 EF7A 85 1D                 sta   <gopher
2342 EF7C
2343 EF7C 20 DD EF              jsr   compare                  Is this 'current's place?
2344 EF7F 90 F2                 bcc   lop2                     If not, keep rising to the top.
2345 EF81
2346 EF81 A5 1D                 lda   <gopher                  Insert 'current' after 'gopher'
2347 EF83 18                    clc   
2348 EF84 65 01                 adc   <memSize
2349 EF86 85 1D                 sta   <gopher
2350 EF88
2351 EF88 E2 20        insert   sep   #ACC                     Save 'current' member.
2352 EF8A A6 01                 ldx   <memSize
2353 EF8C A4 1B                 ldy   <current
2354 EF8E B7 17        lop4     lda   [<listptr],y
2355 EF90 48                    pha   
2356 EF91 C8                    iny   
2357 EF92 CA                    dex   
2358 EF93 D0 F9                 bne   lop4
2359 EF95 88                    dey   
2360 EF96
2361 EF96 B7 0B        lop3     lda   [<blit],y                Move list down to make
2362 EF98 97 17                 sta   [<listptr],y             space for 'current'.
2363 EF9A 88                    dey   
2364 EF9B C4 1D                 cpy   <gopher
2365 EF9D D0 F7                 bne   lop3
2366 EF9F
2367 EF9F C2 20                 rep   #ACC
2368 EFA1 A5 1D                 lda   <gopher
2369 EFA3 18                    clc   
2370 EFA4 65 01                 adc   <memSize
2371 EFA6 3A                    dec   a
2372 EFA7 A8                    tay   
2373 EFA8 E2 20                 sep   #ACC
2374 EFAA A6 01                 ldx   <memSize
2375 EFAC 68           lop5     pla   
2376 EFAD 97 17                 sta   [<listptr],y
2377 EFAF 88                    dey   
2378 EFB0 CA                    dex   
2379 EFB1 D0 F9                 bne   lop5
2380 EFB3 C2 20                 rep   #ACC
2381 EFB5
2382 EFB5 A5 1B                 lda   <current                 Reset 'gopher'.
2383 EFB7 38                    sec   
2384 EFB8 E5 01                 sbc   <memSize
2385 EFBA 85 1D                 sta   <gopher
2386 EFBC
2387 EFBC C6 05        next1    dec   <counter                 Any more members?
2388 EFBE D0 A0                 bne   lop1
2389 EFC0              ;
2390 EFC0              ; Done sorting.  Unlock member list.
2391 EFC0              ;
2392 EFC0
2393 EFC0 A0 32 00              ldy   #CtlList+2               Get pointer to member list.
2394 EFC3 B7 21                 lda   [<CtlPointer],y
2395 EFC5 48                    pha   
2396 EFC6 88                    dey   
2397 EFC7 88                    dey   
2398 EFC8 B7 21                 lda   [<CtlPointer],y
2399 EFCA 48                    pha   
2400 EFCB A0 3C 00              ldy   #newCtlRecord.ctlMoreFlags
2401 EFCE B7 21                 lda   [ctlpointer],y
2402 EFD0 48                    pha   
2403 EFD1
2404 EFD1 20 45 EB              jsr   unlocklist               Unlock member list.
2405 EFD4
2406 EFD4 3B           exit     tsc                            Get rid of local stack space.
2407 EFD5 18                    clc   
2408 EFD6 69 25 00              adc   #worksize
2409 EFD9 1B                    tcs   
2410 EFDA
2411 EFDA 82 CF F8              brl   pop8bytes
2412 EFDD
2413 EFDD
2414 EFDD              ; = = = = = = = = = = = = = = = = = = = = = = = = = =
2415 EFDD              ;          Compare 'current' member string
2416 EFDD              ;          to 'gopher' member string.
2417 EFDD              ; = = = = = = = = = = = = = = = = = = = = = = = = = =
2418 EFDD              ;
2419 EFDD              ;   IN:    listptr = pointer to first member in list.
2420 EFDD              ;          current = index to a member pointer.
2421 EFDD              ;          gopher = index to another member pointer.
2422 EFDD              ;
2423 EFDD              ;  OUT:    Carry is set if current member string is equal to or
2424 EFDD              ;          greater than gopher member string.
2425 EFDD              ;
2426 EFDD              ;          Carry is clear if current member string
2427 EFDD              ;          is less than gopher member string.
2428 EFDD              ;
2429 EFDD A6 33        compare  ldx   <UseCompare+1            Custom compare routine?
2430 EFDF F0 13                 beq   skip10
2431 EFE1
2432 EFE1 A5 1D                 lda   <gopher
2433 EFE3 20 B3 F0              jsr   pushit
2434 EFE6 A5 1B                 lda   <current
2435 EFE8 20 B3 F0              jsr   pushit
2436 EFEB A6 33                 ldx   <UseCompare+1
2437 EFED A5 32                 lda   <UseCompare
2438 EFEF 22 E5 FA FC           jsl   long_call
2439 EFF3 60                    rts   
2440 EFF4
2441 EFF4 A4 1B        skip10   ldy   <current                 Get pointer to first string.
2442 EFF6 B7 17                 lda   [<listptr],y
2443 EFF8 85 0F                 sta   <strg1
2444 EFFA C8                    iny   
2445 EFFB C8                    iny   
2446 EFFC B7 17                 lda   [<listptr],y
2447 EFFE 85 11                 sta   <strg1+2
2448 F000              ;
2449 F000              ; is it a pointer, handle, or rezID?
2450 F000              ;
2451 F000 C8                    iny                            ;bump to member flag
2452 F001 C8                    iny   
2453 F002 B7 17                 lda   [<listptr],y
2454 F004 29 03 00              and   #$0003
2455 F007 F0 31                 beq   pointer
2456 F009 3A                    dec   a
2457 F00A F0 22                 beq   handle
2458 F00C              ;
2459 F00C              ; it's a rezID
2460 F00C              ;
2461 F00C 48                    pha   
2462 F00D 48                    pha                            ;long space for result
2463 F00E A5 03                 lda   <stringType
2464 F010 D0 05                 bne   nullType
2465 F012              ;
2466 F012              ; load P-string
2467 F012              ;
2468 F012 A9 06 80              lda   #rPstring
2469 F015 80 03                 bra   RezCont
2470 F017              ;
2471 F017              ; load C-string
2472 F017              ;
2473 F017 A9 1D 80     nullType lda   #rCstring
2474 F01A
2475 F01A              RezCont   
2476 F01A 48                    pha   
2477 F01B A5 11 48 A5           PushLong <strg1 
2478 F021 A2 1E 0E 22           _LoadResource 
2479 F028 68                    pla   
2480 F029 85 0F                 sta   <strg1
2481 F02B 68                    pla   
2482 F02C 85 11                 sta   <strg1+2
2483 F02E              ;
2484 F02E              ; it's a handle
2485 F02E              ;
2486 F02E A0 02 00     handle   ldy   #2
2487 F031 B7 0F                 lda   [<strg1],y
2488 F033 AA                    tax   
2489 F034 A7 0F                 lda   [<strg1]
2490 F036 85 0F                 sta   <strg1
2491 F038 86 11                 stx   <strg1+2
2492 F03A              ;
2493 F03A              ; strg1 is now a pointer
2494 F03A              ;
2495 F03A A4 1D        pointer  ldy   <gopher                  ;Get pointer to second string.
2496 F03C B7 17                 lda   [<listptr],y
2497 F03E 85 13                 sta   <strg2
2498 F040 C8                    iny   
2499 F041 C8                    iny   
2500 F042 B7 17                 lda   [<listptr],y
2501 F044 85 15                 sta   <strg2+2
2502 F046              ;
2503 F046              ; is strg2 a pointer, handle, or rezID?
2504 F046              ;
2505 F046 C8                    iny                            ;bump to member flag
2506 F047 C8                    iny   
2507 F048 B7 17                 lda   [<listptr],y
2508 F04A 29 03 00              and   #$0003
2509 F04D F0 31                 beq   pointer2
2510 F04F 3A                    dec   a
2511 F050 F0 22                 beq   handle2
2512 F052              ;
2513 F052              ; it's a rezID
2514 F052              ;
2515 F052 48                    pha   
2516 F053 48                    pha                            ;long space for result
2517 F054 A5 03                 lda   <stringType
2518 F056 D0 05                 bne   nullType1
2519 F058              ;
2520 F058              ; load P-string
2521 F058              ;
2522 F058 A9 06 80              lda   #rPstring
2523 F05B 80 03                 bra   RezCont1
2524 F05D              ;
2525 F05D              ; load C-string
2526 F05D              ;
2527 F05D A9 1D 80     nullType1 lda   #rCstring
2528 F060
2529 F060              RezCont1  
2530 F060 48                    pha   
2531 F061 A5 15 48 A5           PushLong <strg2 
2532 F067 A2 1E 0E 22           _LoadResource 
2533 F06E 68                    pla   
2534 F06F 85 13                 sta   <strg2
2535 F071 68                    pla   
2536 F072 85 15                 sta   <strg2+2
2537 F074              ;
2538 F074              ; it's a handle
2539 F074              ;
2540 F074 A0 02 00     handle2  ldy   #2
2541 F077 B7 13                 lda   [<strg2],y
2542 F079 AA                    tax   
2543 F07A A7 13                 lda   [<strg2]
2544 F07C 85 13                 sta   <strg2
2545 F07E 86 15                 stx   <strg2+2
2546 F080              ;
2547 F080              ; strg2 is now a pointer
2548 F080              ;
2549 F080              pointer2  
2550 F080
2551 F080                       LONGA OFF
2552 F080                       LONGI OFF
2553 F080 E2 30                 sep   #ACC+XY                  8-bit registers
2554 F082
2555 F082 A5 03                 lda   <stringType
2556 F084 D0 15                 bne   Cstring
2557 F086              ;
2558 F086              ; --- Pascal strings ------------------------------------------------
2559 F086              ;
2560 F086 A0 00                 ldy   #0
2561 F088 C8           lop10    iny   
2562 F089
2563 F089 98                    tya   
2564 F08A 3A                    dec   a
2565 F08B C7 13                 cmp   [<strg2]                 End of gopher string?
2566 F08D F0 1D                 beq   greater
2567 F08F
2568 F08F C7 0F                 cmp   [<strg1]
2569 F091 F0 1C                 beq   lessthan                 End of current string?
2570 F093
2571 F093 B7 0F                 lda   [<strg1],y               Grab a byte.
2572 F095 D7 13                 cmp   [<strg2],y
2573 F097 F0 EF                 beq   lop10
2574 F099 80 15                 bra   exit10                   Carry flag is ready for exit. 
2575 F09B
2576 F09B              ;
2577 F09B              ; --- Null terminated string -----------------------------------------
2578 F09B              ;
2579 F09B A0 FF        Cstring  ldy   #$FF
2580 F09D C8           lop11    iny   
2581 F09E B7 13                 lda   [<strg2],y               End of gopher string?
2582 F0A0 F0 0A                 beq   greater
2583 F0A2 B7 0F                 lda   [<strg1],y               Grab a byte.
2584 F0A4 F0 09                 beq   lessthan                 End of current string?
2585 F0A6 D7 13                 cmp   [<strg2],y
2586 F0A8 F0 F3                 beq   lop11
2587 F0AA 80 04                 bra   exit10                   Carry flag is ready for exit. 
2588 F0AC
2589 F0AC 38           greater  sec   
2590 F0AD 80 01                 bra   exit10
2591 F0AF
2592 F0AF 18           lessthan clc                            current string < gopher string.
2593 F0B0 C2 30        exit10   rep   #ACC+XY                  16-bit accumulator.
2594 F0B2                       LONGI ON
2595 F0B2                       LONGA ON
2596 F0B2
2597 F0B2 60                    rts   
2598 F0B3
2599 F0B3 FA           pushit   plx   
2600 F0B4 A4 19                 ldy   <listptr+2
2601 F0B6 18                    clc   
2602 F0B7 65 17                 adc   <listptr
2603 F0B9 90 01                 bcc   ok10
2604 F0BB C8                    iny   
2605 F0BC 5A           ok10     phy   
2606 F0BD 48                    pha   
2607 F0BE DA                    phx   
2608 F0BF
2609 F0BF 60                    rts   
2610 F0C0
2611 F0C0                       ENDP 
2612 F0C0
2613 F0C0
2614 F0C0              ;==========================================================================
2615 F0C0              ;
2616 F0C0              ;                   CallDefProc
2617 F0C0              ;
2618 F0C0              ;                   Call list control's defproc.
2619 F0C0              ;
2620 F0C0              ;   IN:    a = command.
2621 F0C0              ;          x = low word of parameter.
2622 F0C0              ;          y = high word of parameter.
2623 F0C0              ;          theList = pointer to ListRec.
2624 F0C0              ;
2625 F0C0              ;  OUT:    a = low word result.
2626 F0C0              ;          x = high word result.
2627 F0C0              ;
2628 F0C0              ;==========================================================================
2629 F0C0                       ENTRY callDefProc
2630 F0C0              callDefProc PROC 
2631 F0C0
2632 F0C0              theList  equ   9
2633 F0C0
2634 F0C0 48                    pha                            Space for result.
2635 F0C1 48                    pha   
2636 F0C2 48                    pha                            Operation number.
2637 F0C3 5A                    phy                            Parameter.
2638 F0C4 DA                    phx   
2639 F0C5 A0 12 00              ldy   #ListCtl+2               Pass list control's handle.
2640 F0C8 B7 09                 lda   [<theList],y
2641 F0CA 48                    pha   
2642 F0CB 88                    dey   
2643 F0CC 88                    dey   
2644 F0CD B7 09                 lda   [<theList],y
2645 F0CF 48                    pha   
2646 F0D0 22 E9 F0 FC           jsl   ListProc                 Call list defProc.
2647 F0D4 68                    pla                            Return result.
2648 F0D5 FA                    plx   
2649 F0D6
2650 F0D6 60                    rts   
2651 F0D7
2652 F0D7                       ENDP 
2653 F0D7
2654 F0D7
2655 F0D7              ;==========================================================================
2656 F0D7              ;
2657 F0D7              ;                   CallDefProc2
2658 F0D7              ;
2659 F0D7              ;                   Call list control's defproc.
2660 F0D7              ;
2661 F0D7              ;   IN:    a = command.
2662 F0D7              ;          x = low word of parameter.
2663 F0D7              ;          y = high word of parameter.
2664 F0D7              ;          theList = pointer to ListRec.
2665 F0D7              ;
2666 F0D7              ;  OUT:    a = low word result.
2667 F0D7              ;          x = high word result.
2668 F0D7              ;
2669 F0D7              ;==========================================================================
2670 F0D7                       ENTRY callDefProc2
2671 F0D7              callDefProc2 PROC 
2672 F0D7
2673 F0D7              CtlHandle equ   9
2674 F0D7
2675 F0D7 48                    pha                            Space for result.
2676 F0D8 48                    pha   
2677 F0D9 48                    pha                            Operation number.
2678 F0DA 5A                    phy                            Parameter.
2679 F0DB DA                    phx   
2680 F0DC A5 0B 48 A5           PushLong <CtlHandle 
2681 F0E2 22 E9 F0 FC           jsl   ListProc                 Call list defProc.
2682 F0E6 68                    pla                            Return result.
2683 F0E7 FA                    plx   
2684 F0E8
2685 F0E8 60                    rts   
2686 F0E9
2687 F0E9                       ENDP 
2688 F0E9              ;---------------------------------------------------------------
2689 F0E9
2690 F0E9              ;
2691 F0E9              ;            APPEND LISTDP1.ASM
2692 F0E9              ;
2693 F0E9              ; 06/05/87 Dan - list_drag wasn't using the list's flag to determine the
2694 F0E9              ;                selection mode and therefore the selection mode was random.
2695 F0E9              ;
2696 F0E9              ; 07/07/87 Dan - fixed a typo, lda #DataSize to lda <DataSize in findFirst.
2697 F0E9              ;
2698 F0E9              ; 07/09/87 Dan - moved startDraw and setClip in front on hitTest in the
2699 F0E9              ;                list_drag routine.  HitTest could call setNewValue which
2700 F0E9              ;                restored the clip region.  Unfortunately the clip region was
2701 F0E9              ;                not saved the first time hitTest was called, so an unknown
2702 F0E9              ;                clip region was restored by setNewValue.
2703 F0E9              ;
2704 F0E9              ; 02/19/88 Dan - ListProc was locking the passed handle for record size
2705 F0E9              ;                operation which passes an invalid handle.
2706 F0E9              ;
2707 F0E9              ; 03/01/88 Dan - Scrolling the list RECT didn't work when scrolled more than
2708 F0E9              ;                64K pixels.
2709 F0E9              ;
2710 F0E9              ; 03/30/87 Dan - Color passed to SetForeColor is now smeared into 4 nibbles and
2711 F0E9              ;                SetFontFlags is called to use all 16 colors no matter the mode.
2712 F0E9              ;
2713 F0E9              ;==========================================================================
2714 F0E9              ;
2715 F0E9              ;                   ListProc.
2716 F0E9              ;
2717 F0E9              ;                   List DefProc
2718 F0E9              ;
2719 F0E9              ;   IN:    PUSH:WORD - operation.
2720 F0E9              ;          PUSH:LONG - operation parameter.
2721 F0E9              ;          PUSH:LONG - handle of control.
2722 F0E9              ;
2723 F0E9              ;  OUT:    LONG - return operation parameter.
2724 F0E9              ;
2725 F0E9              ;==========================================================================
2726 F0E9                       ENTRY ListProc
2727 F0E9              ListProc PROC 
2728 F0E9
2729 F0E9 0B                    phd                            Save original direct page.
2730 F0EA
2731 F0EA 3B                    tsc                            Allocate some work space on the stack.
2732 F0EB 38                    sec   
2733 F0EC E9 44 00              sbc                            #savezpage-1
2734 F0EF 1B                    tcs   
2735 F0F0 5B                    tcd                            Switch direct page into stack.
2736 F0F1
2737 F0F1              ;
2738 F0F1              ; --- Handle Record Size operation ---------------------------
2739 F0F1              ;
2740 F0F1 A5 52                 lda   <operation
2741 F0F3 C9 0C 00              cmp   #recSize
2742 F0F6 D0 0A                 bne   ok1
2743 F0F8
2744 F0F8 A9 38 00              lda   #CtlListBar+4            Return size of control record needed.
2745 F0FB 85 54                 sta   <result
2746 F0FD 64 56                 stz   <result+2
2747 F0FF 82 77 00              brl   exit
2748 F102              ;
2749 F102              ; --- Do common setup ----------------------------------------
2750 F102              ;
2751 F102 20 93 F9     ok1      jsr   LockNLoad                ;Lock and derefence control's handle.
2752 F105
2753 F105 20 BF FA              jsr   getlistRect              ;crect = enclosing RECT.
2754 F108
2755 F108 A0 2C 00              ldy   #CtlMemHeight            ;Break out height of members.
2756 F10B B7 1D                 lda   [cptr],y
2757 F10D 85 13                 sta   <memHeight
2758 F10F
2759 F10F A0 1C 00              ldy   #CtlData
2760 F112 B7 1D                 lda   [cptr],y
2761 F114 85 0F                 sta   <ViewSize
2762 F116 C8                    iny   
2763 F117 C8                    iny   
2764 F118 B7 1D                 lda   [cptr],y
2765 F11A 85 11                 sta   <DataSize
2766 F11C
2767 F11C A0 12 00              ldy   #CtlValue
2768 F11F B7 1D                 lda   [cptr],y
2769 F121 85 0D                 sta   <DisplayTop
2770 F123
2771 F123 A0 10 00              ldy   #CtlFlag
2772 F126 B7 1D                 lda   [cptr],y
2773 F128 29 01 00              and   #1
2774 F12B 85 05                 sta   <strgType
2775 F12D
2776 F12D
2777 F12D 64 54                 stz   <result
2778 F12F 64 56                 stz   <result+2
2779 F131
2780 F131 A5 52                 lda   <operation               ;Get operation number.
2781 F133 30 0C                 bmi   IntMess                  ;bit 15 set means it's one of ours
2782 F135 C9 14 00              cmp   #19+1                    ;(Make sure its in range.)
2783 F138 B0 13                 bcs   SkipItAll
2784 F13A 0A                    asl   a                        ;Double it for word array index.
2785 F13B AA                    tax   
2786 F13C FC 96 F1              jsr   (functions,x)
2787 F13F 80 08                 bra   SkipIntMess
2788 F141              IntMess   
2789 F141 29 FF 00              and   #$00FF                   ;convert for our call look up table
2790 F144 0A                    asl   a                        ;word array index
2791 F145 AA                    tax   
2792 F146 FC BE F1              jsr   (InternalMess,x)
2793 F149
2794 F149              SkipIntMess  
2795 F149 85 54                 sta   <result
2796 F14B 86 56                 stx   <result+2
2797 F14D
2798 F14D              SkipItAll  
2799 F14D A0 04 00              ldy   #4                       ;Unlock the list control's handle.
2800 F150 B7 4A                 lda   [theControl],y
2801 F152 29 FF 7F              and   #$7FFF
2802 F155 97 4A                 sta   [theControl],y
2803 F157
2804 F157              ;
2805 F157              ;if listref is handle or rezID it needs to be unlocked
2806 F157              ; if its old style, we can skip list deref stuff
2807 F157              ;
2808 F157 A0 16 00              ldy   #newCtlRecord.ctlProc+2
2809 F15A B7 1D                 lda   [cptr],y
2810 F15C 10 1B                 bpl   exit                     ;old style
2811 F15E
2812 F15E A5 52                 lda   <operation               ;Don't unlock anything if message is initcntl because
2813 F160 C9 03 00              cmp   #initCntl                ;nothing was locked.
2814 F163 F0 14                 beq   exit
2815 F165
2816 F165 A0 32 00              ldy   #CtlList+2               ;Get handle to member list.
2817 F168 B7 1D                 lda   [cptr],y
2818 F16A 48                    pha   
2819 F16B 88                    dey   
2820 F16C 88                    dey   
2821 F16D B7 1D                 lda   [cptr],y
2822 F16F 48                    pha   
2823 F170
2824 F170 A0 3C 00              ldy   #newCtlRecord.ctlMoreFlags
2825 F173 B7 1D                 lda   [cptr],y
2826 F175 48                    pha   
2827 F176
2828 F176 20 45 EB              jsr   UnlockList
2829 F179
2830 F179 3B           exit     tsc                            ;Allocate some work space on the stack.
2831 F17A 18                    clc   
2832 F17B 69 44 00              adc   #savezpage-1
2833 F17E 1B                    tcs   
2834 F17F
2835 F17F A2 0A 00              ldx   #10                      ;Number of bytes in input parameters.
2836 F182
2837 F182 7A                    ply                            ;Get original zero page.
2838 F183
2839 F183              ;
2840 F183              ; --- Move stack data down over top of parameters ---
2841 F183              ;
2842 F183 3B                    tsc   
2843 F184 5B                    tcd                            ;Make zero page where stack is.
2844 F185 A3 02                 lda   2,s                      ;Move return address down on stack.
2845 F187 95 02                 sta   2,x
2846 F189 A3 00                 lda   0,s
2847 F18B 95 00                 sta   0,x
2848 F18D              ;
2849 F18D              ; --- Adjust stact for popped parameters ---
2850 F18D              ;
2851 F18D 3B                    tsc                            ;Current stack
2852 F18E DA                    phx   
2853 F18F 18                    clc   
2854 F190 63 01                 adc   1,s                      ;plus number of bytes popped
2855 F192 1B                    tcs                            ;equals new stack.
2856 F193
2857 F193 98                    tya                            ;Switch back to original zero page.
2858 F194 5B                    tcd   
2859 F195
2860 F195 6B                    rtl   
2861 F196
2862 F196 BF F8        functions DC W:list_draw                Draw the list, or part.     0
2863 F198 46 F5                 DC W:list_dragRect             Compute the drag RECT.      1
2864 F19A 7D F3                 DC W:list_test                 Hit test.                   2
2865 F19C A8 F5                 DC W:list_init                 Initialize.                 3
2866 F19E 46 F5                 DC W:list_disp                 Dispose.                    4
2867 F1A0 46 F5                 DC W:list_pos                  Move indicator.             5
2868 F1A2 46 F5                 DC W:list_dragParam            Compute drag parameters.    6
2869 F1A4 84 F3                 DC W:list_drag                 Drag indicator.             7
2870 F1A6 46 F5                 DC W:list_action               DefProc action procedure.   8
2871 F1A8 1B F7                 DC W:list_value                New value.                  9
2872 F1AA 46 F5                 DC W:list_params               New parameters.             10
2873 F1AC 46 F5                 DC W:list_move                 Control moved.              11
2874 F1AE 00 00                 DC W:0                         Record size.                12
2875 F1B0 46 F5                 DC W:list_handleEvent                                      13
2876 F1B2 46 F5                 DC W:list_changeActivity                                   14
2877 F1B4 46 F5                 DC W:list_changeBounds                                     15
2878 F1B6 46 F5                 DC W:list_windChangeSize                                   16
2879 F1B8 46 F5                 DC W:list_handleTab                                        17
2880 F1BA 08 F9                 DC W:list_MultiPart                                        18
2881 F1BC 46 F5                 DC W:list_ChangeWinState                                   19 
2882 F1BE
2883 F1BE
2884 F1BE              InternalMess  
2885 F1BE DA F9                 DC W:list_first                Find first selected member. 13 now $8000
2886 F1C0 6C F8                 DC W:list_new                  New list.                   14 now $8001
2887 F1C2 C3 F8                 DC W:list_drawMem              Draw a member.              15 now $8002
2888 F1C4
2889 F1C4                       ENDP 
2890 F1C4
2891 F1C4
2892 F1C4              ;==========================================================================
2893 F1C4              ;
2894 F1C4              ;                   Draw1Member
2895 F1C4              ;
2896 F1C4              ;                   Draw list members.
2897 F1C4              ;
2898 F1C4              ;   IN:    theControl = handle of list control.
2899 F1C4              ;          cptr = pointer of list control.
2900 F1C4              ;          crect = list control's enclosing RECT.
2901 F1C4              ;          parameter = pointer to member to draw,
2902 F1C4              ;                      or zero to draw entire control.
2903 F1C4              ;          DisplayTop = list control's value.
2904 F1C4              ;
2905 F1C4              ;==========================================================================
2906 F1C4                       ENTRY draw1Member
2907 F1C4              draw1Member PROC 
2908 F1C4
2909 F1C4 A0 0F 00              ldy   #CtlFlag-1               Is the control visible?
2910 F1C7 B7 1D                 lda   [cptr],y
2911 F1C9 10 01                 bpl   ok3
2912 F1CB 60                    rts   
2913 F1CC
2914 F1CC 64 33        ok3      stz   <curTextClr              Make sure colors are set first time.
2915 F1CE 64 35                 stz   <curBackClr
2916 F1D0
2917 F1D0 A5 11                 lda   <DataSize
2918 F1D2 F0 04                 beq   exit2
2919 F1D4 A5 0D                 lda   <DisplayTop              Get index of first member in display.
2920 F1D6 D0 01                 bne   ok1                      Are there any members?
2921 F1D8 60           exit2    rts   
2922 F1D9 20 48 FA     ok1      jsr   getmemptr                cworkptr = pointer to desired member.
2923 F1DC              ;                                       cworkptr2 = member text string pointer.
2924 F1DC A5 15                 lda   <crect+y1
2925 F1DE 85 19                 sta   <crect+y2
2926 F1E0
2927 F1E0 A5 0F                 lda   <ViewSize
2928 F1E2 C5 11                 cmp   <DataSize
2929 F1E4 90 02                 bcc   SaveIt                   Is view larger than the total members?
2930 F1E6 A5 11                 lda   <DataSize                Total number is less than view, use it.
2931 F1E8
2932 F1E8 48           SaveIt   pha                            Save counter.
2933 F1E9
2934 F1E9 A5 19        lop2     lda   <crect+y2
2935 F1EB 85 15                 sta   <crect+y1
2936 F1ED 18                    clc   
2937 F1EE 65 13                 adc   <memHeight
2938 F1F0 85 19                 sta   <crect+y2
2939 F1F2
2940 F1F2 A5 4F                 lda   <parameter+1
2941 F1F4 F0 0A                 beq   @yes                     Am I printing the entire list control?
2942 F1F6
2943 F1F6 C5 22                 cmp   <cworkptr+1              Current member same as requested?
2944 F1F8 D0 36                 bne   @to_tonext2
2945 F1FA A5 4E                 lda   <parameter
2946 F1FC C5 21                 cmp   <cworkptr
2947 F1FE D0 30        @to_tonext2 bne   tonext2
2948 F200
2949 F200              @yes      
2950 F200 A0 28 00              ldy   #CtlMemDraw              Is there a custom member draw routine?
2951 F203 B7 1D                 lda   [cptr],y
2952 F205 D0 05                 bne   custom
2953 F207 C8                    iny   
2954 F208 B7 1D                 lda   [cptr],y
2955 F20A F0 2B                 beq   default
2956 F20C              ;
2957 F20C              ;
2958 F20C              ; --- Custom member draw routine -----------------------------------------
2959 F20C              ;
2960 F20C A9 00 00     custom   lda   #0                       Space for result.
2961 F20F 48                    pha   
2962 F210 48                    pha   
2963 F211 20 D5 FA              jsr   pushcrect                Pass address of member's RECT.
2964 F214 D4 23                 pei   <cworkptr+2              Pass member.
2965 F216 D4 21                 pei   <cworkptr
2966 F218 D4 4C                 pei   <theControl+2            Pass handle of list control.
2967 F21A D4 4A                 pei   <theControl
2968 F21C
2969 F21C A0 29 00              ldy   #CtlMemDraw+1            Go to custom member draw routine.
2970 F21F B7 1D                 lda   [cptr],y
2971 F221 AA                    tax   
2972 F222 88                    dey   
2973 F223 B7 1D                 lda   [cptr],y
2974 F225 22 E5 FA FC           jsl   long_call
2975 F229 68                    pla                            Did the routine return a pointer
2976 F22A FA                    plx                            to a string to print?
2977 F22B D0 06                 bne   printStrg
2978 F22D A8                    tay   
2979 F22E D0 03                 bne   printStrg
2980 F230
2981 F230 82 62 00     tonext2  brl   next2
2982 F233
2983 F233 85 25        printStrg sta   <cworkptr2              Save pointer to string to print.
2984 F235 86 27                 stx   <cworkptr2+2
2985 F237
2986 F237              ;
2987 F237              ; --- Default member draw routine -----------------------------------------
2988 F237              ;
2989 F237 A5 17        default  lda   <crect+x1
2990 F239 18                    clc   
2991 F23A 69 0A 00              adc   #10
2992 F23D 48                    pha   
2993 F23E A5 19                 lda   <crect+y2
2994 F240 3A                    dec   a
2995 F241 3A                    dec   a
2996 F242 48                    pha   
2997 F243 A2 04 3A 22           _MoveTo                        Move pen for string print.
2998 F24A
2999 F24A A2 00 00              ldx   #0                       Normal color index.
3000 F24D A0 04 00              ldy   #memFlag
3001 F250 B7 21                 lda   [cworkptr],y             Member must be selected and enabled to
3002 F252 29 C0 00              and   #MEM_SEL+MEM_DISABLE     be drawn as hilited.
3003 F255 C9 80 00              cmp   #$0080
3004 F258 D0 02                 bne   store1
3005 F25A E8                    inx                            Member is selected, next color index.
3006 F25B E8                    inx   
3007 F25C B5 2F        store1   lda   <NorBackClr,x
3008 F25E B4 2B                 ldy   <NorTextClr,x
3009 F260 20 53 F3              jsr   setColor
3010 F263
3011 F263 20 CA F2              jsr   eraseRect                Put down member's background color.
3012 F266
3013 F266 A5 27                 lda   <cworkptr2+2
3014 F268 29 FF 00              and   #$00FF                   Clear high byte.
3015 F26B 48                    pha                            Pass string's address.
3016 F26C D4 25                 pei   <cworkptr2
3017 F26E
3018 F26E A2 04 A6              ldx   #4+256*166               _DrawCString function number.
3019 F271 A5 05                 lda   <strgType                Pascal or null terminated string?
3020 F273 D0 03                 bne   ok2
3021 F275 A2 04 A5              ldx   #4+256*165               _DrawString function number.
3022 F278
3023 F278 22 00 00 E1  ok2      jsl   $E10000                  Print the member's string.
3024 F27C
3025 F27C              ;
3026 F27C              ; ------ Check to dim member -------------------------------------
3027 F27C              ;
3028 F27C A0 04 00              ldy   #memFlag                 Is member disabled?
3029 F27F B7 21                 lda   [cworkptr],y
3030 F281 29 40 00              and   #MEM_DISABLE
3031 F284 F0 0F                 beq   next2
3032 F286
3033 F286 A9 BA F2              lda   #dimMask
3034 F289 20 AE F2              jsr   setmask
3035 F28C
3036 F28C 20 CA F2              jsr   eraseRect
3037 F28F
3038 F28F A9 C2 F2              lda   #norMask
3039 F292 20 AE F2              jsr   setmask
3040 F295
3041 F295 A5 21        next2    lda   <cworkptr
3042 F297 A0 2E 00              ldy   #CtlMemSize
3043 F29A 18                    clc   
3044 F29B 77 1D                 adc   [cptr],y
3045 F29D 90 02                 bcc   store2
3046 F29F E6 23                 inc   <cworkptr+2
3047 F2A1 85 21        store2   sta   <cworkptr
3048 F2A3
3049 F2A3 68                    pla                            Get counter.
3050 F2A4 3A                    dec   a                        Less the one just printed.
3051 F2A5 F0 12                 beq   exit                     Done?
3052 F2A7
3053 F2A7 48                    pha                            Save counter
3054 F2A8
3055 F2A8 20 64 FA              jsr   derefMem                 cworkptr2 = cworkptr->memPtr.
3056 F2AB
3057 F2AB 4C E9 F1              jmp   lop2
3058 F2AE
3059 F2AE F4 FC 00     setmask  pea   norMask>>16
3060 F2B1 48                    pha   
3061 F2B2 A2 04 32 22           _SetPenMask 
3062 F2B9
3063 F2B9 60           exit     rts   
3064 F2BA
3065 F2BA 55 AA 55 AA  dimMask  DC B:$55,$AA,$55,$AA,$55,$AA,$55,$AA
3066 F2C2 FF FF FF FF  norMask  DC B:$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF
3067 F2CA
3068 F2CA
3069 F2CA                       ENTRY eraseRect
3070 F2CA              eraseRect  
3071 F2CA 20 D5 FA              jsr   pushcrect                Pass address of 'crect'.
3072 F2CD A2 04 55 22           _EraseRect                     Shutgun member.
3073 F2D4 60                    rts   
3074 F2D5
3075 F2D5                       ENDP 
3076 F2D5
3077 F2D5
3078 F2D5              ;==========================================================================
3079 F2D5              ;
3080 F2D5              ;                   StartDraw
3081 F2D5              ;
3082 F2D5              ;                   Set up for drawing.
3083 F2D5              ;
3084 F2D5              ;==========================================================================
3085 F2D5              ;	ENTRY	startDraw
3086 F2D5              startDraw PROC 
3087 F2D5
3088 F2D5              ;
3089 F2D5              ; --- Grab list control's color table ----------------------------
3090 F2D5              ;
3091 F2D5 A0 24 00              ldy   #CtlColor                Get pointer to color table.
3092 F2D8 B7 1D                 lda   [cptr],y
3093 F2DA AA                    tax   
3094 F2DB C8                    iny   
3095 F2DC C8                    iny   
3096 F2DD B7 1D                 lda   [cptr],y
3097 F2DF D0 09                 bne   store2                   Default color table?
3098 F2E1 9B                    txy   
3099 F2E2 D0 06                 bne   store2
3100 F2E4
3101 F2E4 A9 FC 00              lda   #colorTable>>16          Use default color table.
3102 F2E7 A2 23 F3              ldx   #colorTable
3103 F2EA
3104 F2EA 86 25        store2   stx   <cworkptr2
3105 F2EC 85 27                 sta   <cworkptr2+2
3106 F2EE
3107 F2EE A0 08 00     ok3      ldy   #8
3108 F2F1 B7 25        lop1     lda   [cworkptr2],y
3109 F2F3 BB                    tyx   
3110 F2F4 95 29                 sta   <FrameClr,x
3111 F2F6 88                    dey   
3112 F2F7 88                    dey   
3113 F2F8 10 F7                 bpl   lop1
3114 F2FA
3115 F2FA A2 04 36 22           _PenNormal 
3116 F301
3117 F301 48                    pha                            Save current text writing mode.
3118 F302 A2 04 9D 22           _GetTextMode 
3119 F309 68                    pla   
3120 F30A 85 0B                 sta   <TextMode
3121 F30C
3122 F30C 48                    pha                            Save current font flags.
3123 F30D A2 04 99 22           _GetFontFlags 
3124 F314 68                    pla   
3125 F315 85 03                 sta   <saveFontFlags
3126 F317
3127 F317 A9 04 00              lda   #4                       Copy foreground only.
3128 F31A
3129 F31A                       ENTRY SetTextMode
3130 F31A              SetTextMode  
3131 F31A 48                    pha   
3132 F31B A2 04 9C 22           _SetTextMode 
3133 F322
3134 F322 60                    rts   
3135 F323
3136 F323 00 00        colorTable DC W:$0000                   Black frame.
3137 F325 00 00                 DC W:$0000                     Back normal text.
3138 F327 0F 00                 DC W:$000F                     White selected text.
3139 F329 0F 00                 DC W:$000F                     White normal background.
3140 F32B 00 00                 DC W:$0000                     Black selected background.
3141 F32D
3142 F32D                       ENDP 
3143 F32D
3144 F32D
3145 F32D              ;==========================================================================
3146 F32D              ;
3147 F32D              ;                   SetClip
3148 F32D              ;
3149 F32D              ;                   Set port's clip region to list control.
3150 F32D              ;
3151 F32D              ;==========================================================================
3152 F32D                       ENTRY setClip
3153 F32D              setClip  PROC 
3154 F32D
3155 F32D 48                    pha                            Save for result.
3156 F32E 48                    pha   
3157 F32F A2 04 67 22           _NewRgn 
3158 F336 A3 01                 lda   1,s                      Save region handle.
3159 F338 85 41                 sta   <oldClip
3160 F33A A3 03                 lda   3,s
3161 F33C 85 43                 sta   <oldClip+2
3162 F33E A2 04 25 22           _GetClip                       Copy port's original clip region.
3163 F345
3164 F345
3165 F345                       ENTRY setClip2
3166 F345              setClip2                                ;
3167 F345 20 37 FA              jsr   insetcrect               Subtract frame from 'crect'.
3168 F348
3169 F348 20 D5 FA              jsr   pushcrect                Set clip to list interior.
3170 F34B A2 04 26 22           _ClipRect 
3171 F352
3172 F352 60                    rts   
3173 F353
3174 F353                       ENDP 
3175 F353
3176 F353
3177 F353              ;==========================================================================
3178 F353              ;
3179 F353              ;                   SetColor
3180 F353              ;
3181 F353              ;                   Set color of text and background.
3182 F353              ;
3183 F353              ;   IN:    y = text color.
3184 F353              ;          a = background color.
3185 F353              ;
3186 F353              ;==========================================================================
3187 F353                       ENTRY setColor
3188 F353              setColor PROC 
3189 F353
3190 F353 C4 33                 cpy   <curTextClr              Have the colors changed?
3191 F355 D0 04                 bne   setColor2
3192 F357 C5 35                 cmp   <curBackClr
3193 F359 F0 21                 beq   exit                     If both the same, no need to set.
3194 F35B
3195 F35B                       ENTRY setColor2
3196 F35B              setColor2                               ;
3197 F35B 84 33                 sty   <curTextClr              Save new colors as current colors.
3198 F35D 85 35                 sta   <curBackClr
3199 F35F
3200 F35F 48                    pha                            Set background color for normal.
3201 F360 A2 04 38 22           _SetSolidBackPat 
3202 F367
3203 F367 A5 33                 lda   <curTextClr              Smear color into all four nibbles.
3204 F369 0A                    asl   a
3205 F36A 0A                    asl   a
3206 F36B 0A                    asl   a
3207 F36C 0A                    asl   a
3208 F36D 05 33                 ora   <curTextClr
3209 F36F 48                    pha   
3210 F370 EB                    xba   
3211 F371 03 01                 ora   1,s
3212 F373 83 01                 sta   1,s
3213 F375 A2 04 A0 22           _SetForeColor                  Set text color.
3214 F37C
3215 F37C 60           exit     rts   
3216 F37D
3217 F37D                       ENDP 
3218 F37D
3219 F37D
3220 F37D              ;======================================================================
3221 F37D              ;
3222 F37D              ;                   List_Test
3223 F37D              ;
3224 F37D              ;                   Hit test list control.
3225 F37D              ;
3226 F37D              ;======================================================================
3227 F37D                       ENTRY list_test
3228 F37D              list_test PROC 
3229 F37D
3230 F37D A9 88 00              lda   #$0088
3231 F380 A2 00 00              ldx   #0
3232 F383 60                    rts   
3233 F384
3234 F384                       ENDP 
3235 F384
3236 F384
3237 F384              ;======================================================================
3238 F384              ;
3239 F384              ;                   List_Drag
3240 F384              ;
3241 F384              ;                   Track control list control.
3242 F384              ;
3243 F384              ;   IN:    cptr = pointer to list control.
3244 F384              ;          theControl = handle of list control.
3245 F384              ;          crect = list control's enclosing RECT.
3246 F384              ;
3247 F384              ;  OUT:    a = part hit, zero if no hit.
3248 F384              ;          x = zero.
3249 F384              ;
3250 F384              ;
3251 F384              ; Change History
3252 F384              ;
3253 F384              ; 30 Aug 88
3254 F384              ;
3255 F384              ; No longer uses in-line data storage for the event record.  Instead,
3256 F384              ; we use that stack.
3257 F384              ;
3258 F384              ; We also have added an additional word in the direct page area
3259 F384              ; that we get inside the def-proc.
3260 F384              ;
3261 F384              ;======================================================================
3262 F384                       ENTRY list_drag
3263 F384              list_drag PROC 
3264 F384
3265 F384 A2 02 F4              ldx   #single-1                Single mode handler.
3266 F387 A0 10 00              ldy   #CtlFlag
3267 F38A B7 1D                 lda   [<cptr],y
3268 F38C 29 02 00              and   #2                       Single mode only?
3269 F38F D0 14                 bne   store1
3270 F391
3271 F391 AF 25 C0 00           lda   >$00C025                 Get status of Open Apple and Shift keys.
3272 F395 29 81 00              and   #COMMAND+SHIFT           Get just the Command and Shift key bits.
3273 F398 F0 0B                 beq   store1                   Neither Command or Shift key down?
3274 F39A A2 0A F4              ldx   #random-1                Random mode handler.
3275 F39D 29 80 00              and   #COMMAND                 Was the command key down?
3276 F3A0 D0 03                 bne   store1
3277 F3A2 A2 10 F4              ldx   #range-1                 Shift key must be down, range handler.
3278 F3A5 86 37        store1   stx   <constraint              Remember what the keys were at start.
3279 F3A7
3280 F3A7 20 D5 F2              jsr   startDraw                Set up for drawing.
3281 F3AA 20 BF FA              jsr   getlistRect              crect = enclosing RECT.
3282 F3AD 20 2D F3              jsr   setClip                  Save current clip and set to list.
3283 F3B0
3284 F3B0 20 4F F4              jsr   getMpoint                param = current mouse position.
3285 F3B3 20 29 F5              jsr   hitTest                  Find out which member we are over.
3286 F3B6 D0 03                 bne   ok1                      All done if we don't start over a member.
3287 F3B8 82 6A 00              brl   endDraw
3288 F3BB
3289 F3BB 85 39        ok1      sta   <curMember
3290 F3BD
3291 F3BD A5 37                 lda   <constraint
3292 F3BF C9 10 F4              cmp   #range-1
3293 F3C2 D0 3C                 bne   enter1
3294 F3C4              ;
3295 F3C4              ; --- Find hook for shift --------------------------------------------
3296 F3C4              ;
3297 F3C4 A9 FF FF              lda   #$FFFF                   Find last selected or curMember.
3298 F3C7 20 7F F4              jsr   findFirst
3299 F3CA 85 3D                 sta   <endRange
3300 F3CC
3301 F3CC A9 01 00              lda   #$0001                   Find first selected or curMember.
3302 F3CF 20 7F F4              jsr   findFirst
3303 F3D2 85 3B                 sta   <startRange
3304 F3D4
3305 F3D4 C5 39                 cmp   <curMember               The one that's not curMember is hook.
3306 F3D6 F0 06                 beq   lastIsHook
3307 F3D8
3308 F3D8 A6 39                 ldx   <curMember               curMember is below startRange,
3309 F3DA 86 3D                 stx   <endRange                so force to be the endRange and hook.
3310 F3DC 80 02                 bra   store2
3311 F3DE
3312 F3DE A5 3D        lastIsHook lda   <endRange
3313 F3E0 85 3F        store2   sta   <hookMember
3314 F3E2 80 1C                 bra   enter1
3315 F3E4
3316 F3E4 A5 01        poll     lda   <lastEventCode           Was the last event a button up?
3317 F3E6 C9 02 00              cmp   #2
3318 F3E9 F0 3A                 beq   endDraw                  If yes, then done.
3319 F3EB
3320 F3EB 20 4F F4              jsr   getMpoint                Get current mouse position.
3321 F3EE
3322 F3EE 20 BF FA              jsr   getlistRect              crect = list control's enclosing RECT.
3323 F3F1 20 37 FA              jsr   insetcrect               Subtract frame from 'crect'.
3324 F3F4
3325 F3F4 20 29 F5              jsr   hitTest                  Find out which member we are over.
3326 F3F7 AA                    tax                            Over no member?
3327 F3F8 F0 EA                 beq   poll                     If not, leave current member.
3328 F3FA C5 39                 cmp   <curMember               Same member?
3329 F3FC F0 E6                 beq   poll                     Nothing to do if the same.
3330 F3FE 85 39                 sta   <curMember               Remember index of member.
3331 F400
3332 F400 D4 37        enter1   pei   <constraint              Put handler on stack,
3333 F402 60                    rts                            and go to it.
3334 F403
3335 F403              ;
3336 F403              ; --- Command and Shift not pressed handler ------------------------------
3337 F403              ;
3338 F403 A5 39        single   lda   <curMember               Current member is the only one
3339 F405 85 3B                 sta   <startRange              that should be selected.
3340 F407 85 3D                 sta   <endRange
3341 F409 80 15                 bra   doit
3342 F40B
3343 F40B              ;
3344 F40B              ; --- Command key handler -------------------------------------------------
3345 F40B              ;
3346 F40B 64 3B        random   stz   <startRange              Set 'no deselections' flag.
3347 F40D C6 3B                 dec   <startRange
3348 F40F 80 0F                 bra   doit
3349 F411              ;
3350 F411              ; --- Shift key handler ---------------------------------------------------
3351 F411              ;
3352 F411              ; ------ Find first selected or curMember ---------------------------------
3353 F411              ;
3354 F411 A5 39        range    lda   <curMember
3355 F413 A6 3F                 ldx   <hookMember
3356 F415 C5 3F                 cmp   <hookMember
3357 F417 90 03                 bcc   store3
3358 F419
3359 F419 9B                    txy   
3360 F41A AA                    tax   
3361 F41B 98                    tya   
3362 F41C
3363 F41C 85 3B        store3   sta   <startRange
3364 F41E 86 3D                 stx   <endRange
3365 F420              doit      
3366 F420 20 B3 F4              jsr   ck_deselected            Check if members need to be deselected.
3367 F423 80 BF                 bra   poll
3368 F425
3369 F425              endDraw  proc export 
3370 F425 20 9A F5              jsr   setOldClip               Restore port's clip region.
3371 F428
3372 F428 D4 43                 pei   <oldClip+2               Free save region.
3373 F42A D4 41                 pei   <oldClip
3374 F42C A2 04 68 22           _DisposeRgn 
3375 F433
3376 F433 A0 00 00              ldy   #0                       Black text on,
3377 F436 A9 0F 00              lda   #15                      a white background.
3378 F439 20 53 F3              jsr   setColor                 Set the text and background color.
3379 F43C
3380 F43C A5 0B                 lda   <TextMode                Original text writing mode.
3381 F43E 20 1A F3              jsr   SetTextMode              Restore original text writing mode.
3382 F441
3383 F441 D4 03                 pei   <saveFontFlags           Restore.
3384 F443 A2 04 98 22           _SetFontFlags 
3385 F44A
3386 F44A A9 01 00              lda   #1                       Return 'drag completed' flag.
3387 F44D AA                    tax   
3388 F44E
3389 F44E 60                    rts   
3390 F44F
3391 F44F                       EndP 
3392 F44F
3393 F44F
3394 F44F              ; = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = =
3395 F44F              ;          Get current mouse position.
3396 F44F              ; = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = =
3397 F44F
3398 F44F              getMpoint proc 
3399 F44F 3B                    tsc   
3400 F450 38                    sec   
3401 F451 E9 10 00              sbc   #16
3402 F454 1B                    tcs   
3403 F455
3404 F455 48                    pha                            space for result
3405 F456 F4 04 04              pea   $0404                    Take a mouse up and desk accessory.
3406 F459 F4 00 00              pea   0000                     pointer to record on stack
3407 F45C 1A                    inc   a
3408 F45D 48                    pha   
3409 F45E A2 06 0A 22           _GetNextEvent 
3410 F465 68                    pla                            Get rid of returned code.
3411 F466
3412 F466 68                    pla                            get event code
3413 F467 85 01                 sta   <LastEventCode
3414 F469 68                    pla                            ignore message
3415 F46A 68                    pla   
3416 F46B 68                    pla                            ignore time
3417 F46C 68                    pla   
3418 F46D 68                    pla                            put loc into parameter
3419 F46E 85 4E                 sta   <parameter
3420 F470 68                    pla   
3421 F471 85 50                 sta   <parameter+2
3422 F473 68                    pla                            ignore flags
3423 F474 20 D0 FA              jsr   pushparam                Convert current mouse position to local.
3424 F477 A2 04 85 22           _GlobalToLocal 
3425 F47E
3426 F47E 60                    rts   
3427 F47F
3428 F47F                       ENDP 
3429 F47F
3430 F47F
3431 F47F              ;==========================================================================
3432 F47F              ;
3433 F47F              ;                   FindFirst
3434 F47F              ;
3435 F47F              ;                   Find first or last selected member.
3436 F47F              ;
3437 F47F              ;   IN:    a = $0001 to find first selected or curMember.
3438 F47F              ;              $FFFF to find last selected or curMember.
3439 F47F              ;          cptr = pointer to list control.
3440 F47F              ;
3441 F47F              ;  OUT:    a = found member.
3442 F47F              ;          startRange = trash.
3443 F47F              ;          hookMember = trash.
3444 F47F              ;
3445 F47F              ;==========================================================================
3446 F47F                       ENTRY findFirst
3447 F47F              findFirst PROC 
3448 F47F
3449 F47F 85 3F                 sta   <hookMember              Remember direction.
3450 F481
3451 F481 A9 00 00              lda   #0                       First member.
3452 F484 A6 3F                 ldx   <hookMember              Direction?
3453 F486 10 03                 bpl   store1
3454 F488 A5 11                 lda   <DataSize                Total number of members.
3455 F48A 1A                    inc   a
3456 F48B 85 3B        store1   sta   <startRange
3457 F48D
3458 F48D A5 3B        lop1     lda   <startRange              Member counter.
3459 F48F 18                    clc   
3460 F490 65 3F                 adc   <hookMember              Plus direction.
3461 F492 85 3B                 sta   <startRange
3462 F494 F0 1B                 beq   offList                  Off top of list?
3463 F496
3464 F496 C5 11                 cmp   <DataSize                Off end of list?
3465 F498 90 02                 bcc   ok1
3466 F49A D0 15                 bne   offList
3467 F49C
3468 F49C C5 39        ok1      cmp   <curMember               Is this the current member selected?
3469 F49E F0 0D                 beq   exit                     If yes, I've found my target.
3470 F4A0 20 48 FA              jsr   getmemptr                Get pointer to member.
3471 F4A3
3472 F4A3 A0 04 00              ldy   #memFlag                 Check member's state.
3473 F4A6 B7 21                 lda   [cworkptr],y
3474 F4A8 29 80 00              and   #MEM_SEL
3475 F4AB F0 E0                 beq   lop1
3476 F4AD
3477 F4AD A5 3B        exit     lda   <startRange              Return found member.
3478 F4AF 18                    clc                            Found.
3479 F4B0 60                    rts   
3480 F4B1
3481 F4B1 38           offList  sec                            Not found.
3482 F4B2 60                    rts   
3483 F4B3
3484 F4B3                       ENDP 
3485 F4B3
3486 F4B3
3487 F4B3              ;==========================================================================
3488 F4B3              ;
3489 F4B3              ;                   Ck_Deselected
3490 F4B3              ;
3491 F4B3              ;                   Check if some members need to be deselected.
3492 F4B3              ;
3493 F4B3              ;   IN:    startRange = negative if no deselections, else start of selected.
3494 F4B3              ;          endRange = last selected member in range.
3495 F4B3              ;
3496 F4B3              ;  OUT:    All members between startRange and endRange are selected,
3497 F4B3              ;          all outside are deselected,
3498 F4B3              ;          unless startRange is negative, then no member is deselected.
3499 F4B3              ;
3500 F4B3              ;==========================================================================
3501 F4B3                       ENTRY ck_deselected
3502 F4B3              ck_deselected PROC 
3503 F4B3
3504 F4B3 E6 3D                 inc   <endRange                For easy compare.
3505 F4B5
3506 F4B5 A9 BB F4              lda   #selector
3507 F4B8 82 55 05              brl   walkOfLife
3508 F4BB
3509 F4BB AA           selector tax                            Put current member index in X.
3510 F4BC
3511 F4BC A0 04 00              ldy   #memFlag
3512 F4BF B7 21                 lda   [cworkptr],y             Get member's flag.
3513 F4C1 48                    pha                            Save copy of original
3514 F4C2
3515 F4C2 E4 39                 cpx   <curMember
3516 F4C4 D0 0F                 bne   ckSelect
3517 F4C6
3518 F4C6 A4 3B                 ldy   <startRange              Was the command key down?
3519 F4C8 30 06                 bmi   flipit                   If yes, flip the member's start.
3520 F4CA
3521 F4CA AA                    tax                            Save member's flag.
3522 F4CB 89 80 00              bit   #MEM_SEL
3523 F4CE D0 56                 bne   exit                     If already selected, no need to redraw it.
3524 F4D0
3525 F4D0 49 80 00     flipit   eor   #MEM_SEL                 Flip the member's state.
3526 F4D3 80 1E                 bra   store1
3527 F4D5
3528 F4D5 A4 3B        ckSelect ldy   <startRange              Special 'no deselect' flag?
3529 F4D7 30 4D                 bmi   exit
3530 F4D9
3531 F4D9 E4 3B                 cpx   <startRange              Inside or outside range?
3532 F4DB 90 04                 bcc   outSide
3533 F4DD E4 3D                 cpx   <endRange
3534 F4DF 90 0A                 bcc   inSide
3535 F4E1
3536 F4E1 49 80 00     outSide  eor   #MEM_SEL                 Flip member's state.
3537 F4E4 89 80 00              bit   #MEM_SEL
3538 F4E7 D0 3D                 bne   exit                     No need to redraw if it was not selected.
3539 F4E9 80 08                 bra   store1                   Change member's state and redraw.
3540 F4EB
3541 F4EB 49 80 00     inSide   eor   #MEM_SEL                 Flip member's state.
3542 F4EE 89 80 00              bit   #MEM_SEL
3543 F4F1 F0 33                 beq   exit                     Is member already selected?
3544 F4F3
3545 F4F3 E2 20        store1   shortm 8 bit acc.
3546 F4F5 AA                    tax                            ; Save memFlag
3547 F4F6 A0 10 00              ldy   #CtlFlag                 ; Check the control record's flag to see if
3548 F4F9 B7 1D                 lda   [<cptr],y                ; we need to check the MEM_NEVER flag
3549 F4FB 89 40                 bit   #TEST_MEM_NEVER
3550 F4FD F0 08                 beq   @1
3551 F4FF
3552 F4FF 8A                    txa                            ; get the memFlag back in x-reg
3553 F500
3554 F500 89 20                 bit   #MEM_NEVER
3555 F502 F0 03                 beq   @1                       ok to store
3556 F504 29 7F                 and   #$FF-MEM_SEL             turn off selection
3557 F506 AA                    tax   
3558 F507
3559 F507 A0 04 00     @1       ldy   #memFlag
3560 F50A 8A                    txa   
3561 F50B 97 21                 sta   [cworkptr],y
3562 F50D C2 20                 longm                          16 bit acc.
3563 F50F 48                    pha                            save new value
3564 F510
3565 F510 20 BF FA              jsr   getlistRect              crect = enclosing RECT.
3566 F513 20 37 FA              jsr   insetcrect               Subtract frame from 'crect'.
3567 F516
3568 F516 A5 21                 lda   <cworkptr
3569 F518 85 4E                 sta   <parameter
3570 F51A A5 23                 lda   <cworkptr+2
3571 F51C 85 50                 sta   <parameter+2
3572 F51E 68                    pla                            get new flags back
3573 F51F C3 01                 cmp   1,s                      did this member change? (Owen Rubin)
3574 F521 F0 03                 beq   exit
3575 F523
3576 F523 20 C4 F1              jsr   draw1Member              Redraw the member.
3577 F526              exit      
3578 F526 68                    pla                            exit point for stack cleanup
3579 F527 18                    clc   
3580 F528 60                    rts   
3581 F529
3582 F529                       ENDP 
3583 F529
3584 F529
3585 F529              ;==========================================================================
3586 F529              ;
3587 F529              ;                   HitTest
3588 F529              ;
3589 F529              ;                   Hit test list.
3590 F529              ;
3591 F529              ;   IN:    parameter+y1 = Y coordinate to check.
3592 F529              ;          parameter+x1 = X coordinate to check.
3593 F529              ;          crect = list's enclosing RECT less frame.
3594 F529              ;
3595 F529              ;  OUT:    a = member's number, zero if none.
3596 F529              ;          crect = member's enclosing RECT.
3597 F529              ;          cworkptr = pointer to member.
3598 F529              ;
3599 F529              ;          This routine is called only from within the defProc.
3600 F529              ;
3601 F529              ;==========================================================================
3602 F529                       ENTRY hitTest
3603 F529              hitTest  PROC 
3604 F529
3605 F529 48                    pha                            Space for result.
3606 F52A 20 D0 FA              jsr   pushparam                Pass pointer to point in 'parameter'.
3607 F52D 20 D5 FA              jsr   pushcrect                Pass list's RECT.
3608 F530 A2 04 4F 22           _PtInRect                      Test if 'parameter' is within 'crect'.
3609 F537 68                    pla                            Zero if not inside.
3610 F538 D0 3D                 bne   ok2
3611 F53A
3612 F53A              ;
3613 F53A              ; --- Not inside the list RECT -------------------------------------
3614 F53A              ;
3615 F53A A5 4E        outside  lda   <parameter+y1            Get the Y coordinate.
3616 F53C 30 13                 bmi   offTop
3617 F53E C5 15                 cmp   <crect+y1                Off top?
3618 F540 90 0F                 bcc   offTop
3619 F542
3620 F542 C5 19                 cmp   <crect+y2
3621 F544 B0 15                 bcs   offBottom                Off bottom?
3622 F546
3623 F546
3624 F546              ;==========================================================================
3625 F546              ;
3626 F546              ;          List_DragRect                compute the drag RECT
3627 F546              ;          List_Pos                     move indicator
3628 F546              ;          List_DragParam               compute drag parameters
3629 F546              ;          List_Action                  DefProc action procedure
3630 F546              ;          List_Params                  new parameters
3631 F546              ;          List_Move                    control moved
3632 F546              ;          List_Disp                    dispose control
3633 F546              ;          List_ChangeBounds            bounds rect of control is about to change
3634 F546              ;          List_WindChangeSize          window control is in is being zoomed or resized
3635 F546              ;
3636 F546              ;==========================================================================
3637 F546                       ENTRY list_dragRect
3638 F546              list_dragRect  
3639 F546                       ENTRY list_pos
3640 F546              list_pos  
3641 F546                       ENTRY list_dragParam
3642 F546              list_dragParam  
3643 F546                       ENTRY list_action
3644 F546              list_action  
3645 F546                       ENTRY list_params
3646 F546              list_params  
3647 F546                       ENTRY list_move
3648 F546              list_move  
3649 F546                       ENTRY list_changeBounds
3650 F546              list_changeBounds  
3651 F546                       ENTRY list_windChangeSize
3652 F546              list_windChangeSize  
3653 F546                       ENTRY list_ChangeWinState
3654 F546              list_ChangeWinState  
3655 F546
3656 F546 A9 00 00     retNull  lda   #0                       No hit flag.
3657 F549 60                    rts   
3658 F54A
3659 F54A A9 01 00     topLimit lda   #1                       Top limit, first member.
3660 F54D 60                    rts   
3661 F54E
3662 F54E A5 11        bottomLimit lda   <DataSize             Bottom limit, last member.
3663 F550 60           toexit   rts   
3664 F551
3665 F551 A5 0D        offTop   lda   <DisplayTop
3666 F553 F0 FB                 beq   toexit                   Value is zero if there are no members.
3667 F555 3A                    dec   a
3668 F556 F0 F2                 beq   topLimit                 Only one member?
3669 F558
3670 F558 48                    pha                            Save member hit.
3671 F559 80 0F                 bra   common
3672 F55B
3673 F55B A5 0D        offBottom lda   <DisplayTop             First member in display,
3674 F55D 18                    clc   
3675 F55E 65 0F                 adc   <ViewSize                plus view size,
3676 F560 C5 11                 cmp   <DataSize                can't be larger than total size.
3677 F562 F0 02                 beq   ok3
3678 F564 B0 E8                 bcs   bottomLimit              Choose last member if at bottom.
3679 F566
3680 F566 48           ok3      pha                            Save member hit.
3681 F567 A5 0D                 lda   <DisplayTop
3682 F569 1A                    inc   a
3683 F56A
3684 F56A 85 0D        common   sta   <DisplayTop              Set new value.
3685 F56C 20 75 F9              jsr   setNewValue
3686 F56F
3687 F56F 20 BF FA              jsr   getlistRect              crect = enclosing RECT.
3688 F572 20 45 F3              jsr   setClip2                 Set clip back to list.
3689 F575              ;
3690 F575              ; Unlock listRef if it was a handle (locked by setNewValue)
3691 F575              ;
3692 F575
3693 F575
3694 F575 68                    pla                            Return new member.
3695 F576 60                    rts   
3696 F577
3697 F577              ;
3698 F577              ; --- Point in list's RECT, find which member ---------------------------------
3699 F577              ;
3700 F577 A5 11        ok2      lda   <DataSize                Get total number of members.
3701 F579 1A                    inc   a
3702 F57A 85 50                 sta   <parameter+2             Keep here (X coordinate won't be needed).
3703 F57C
3704 F57C A5 0D                 lda   <DisplayTop              Get index of first member in display.
3705 F57E F0 18                 beq   exit                     Any members?
3706 F580 A8                    tay                            Keep in Y
3707 F581 88                    dey   
3708 F582
3709 F582 A6 4E                 ldx   <parameter               Get the Y coordinate to check.
3710 F584 C8           lop1     iny                            Next member.
3711 F585 C4 50                 cpy   <parameter+2             Pass total number of members?
3712 F587 90 03                 bcc   ok1
3713 F589
3714 F589 A5 11                 lda   <DataSize                Use last member.
3715 F58B 60                    rts   
3716 F58C
3717 F58C A5 15        ok1      lda   <crect+y1
3718 F58E 18                    clc   
3719 F58F 65 13                 adc   <memHeight
3720 F591 85 15                 sta   <crect+y1
3721 F593
3722 F593 E4 15                 cpx   <crect+y1
3723 F595 B0 ED                 bcs   lop1
3724 F597
3725 F597 98                    tya                            Return member index in A.
3726 F598 A8           exit     tay                            Set return flag.
3727 F599 60                    rts   
3728 F59A
3729 F59A                       EndP 
3730 F59A
3731 F59A
3732 F59A              setOldClip proc export 
3733 F59A A6 43                 ldx   <oldClip+2               Restore port's clip region.
3734 F59C A5 41                 lda   <oldClip
3735 F59E
3736 F59E                       ENTRY setClip3
3737 F59E DA           setClip3 phx   
3738 F59F 48                    pha   
3739 F5A0 A2 04 24 22           _SetClip 
3740 F5A7 60                    rts   
3741 F5A8
3742 F5A8
3743 F5A8                       ENDP 
3744 F5A8
3745 F5A8              ;==========================================================================
3746 F5A8              ;
3747 F5A8              ;                   List_Init
3748 F5A8              ;
3749 F5A8              ;                   Additional initialization to list control.
3750 F5A8              ;
3751 F5A8              ;   IN:    parameter = pointer to ListRec.
3752 F5A8              ;
3753 F5A8              ;  Modified Dec 7, '88 by Konstantin Othmer
3754 F5A8              ;
3755 F5A8              ;   The CtlFlag bits in the NewCtlRecord were not getting set.  The documentation
3756 F5A8              ; is wrong about the use of the ctlflag field.  It contains the p-string and
3757 F5A8              ; c-string info, not stuff about the scroll bar.
3758 F5A8              ;
3759 F5A8              ;
3760 F5A8              ; December 8, 1988  Konstantin  
3761 F5A8              ;
3762 F5A8              ;  The DataSize and ViewSize fields were not getting set.
3763 F5A8              ;
3764 F5A8              ; Made it so bit 2 of the ListType field controls whether the
3765 F5A8              ; scroll bar goes on the outside or the inside of the listrect.  If it's a 1,
3766 F5A8              ; it goes on the inside.  0 means outside (like before).
3767 F5A8              ;
3768 F5A8              ;
3769 F5A8              ; March 9, 1989     Konstantin
3770 F5A8              ;
3771 F5A8              ; When ListView was other than 0, the record was not getting updated.
3772 F5A8              ; 
3773 F5A8              ;
3774 F5A8              ; 17 Apr 89         Steven Glass, Harry Yee and James T. Mensch
3775 F5A8              ;
3776 F5A8              ; We validate the first member to display with respect to the view size 
3777 F5A8              ; and data size.  First member <= DataSize - ViewSize.
3778 F5A8              ;
3779 F5A8              ;==========================================================================
3780 F5A8                       ENTRY list_init
3781 F5A8              list_init PROC 
3782 F5A8              ;
3783 F5A8              ; --- Initialize the control's member draw and height fields ----------------
3784 F5A8              ;
3785 F5A8
3786 F5A8 A0 16 00              ldy   #newCtlRecord.ctlProc+2
3787 F5AB B7 1D                 lda   [cptr],y
3788 F5AD 30 03                 bmi   NewStuff
3789 F5AF 82 AF 00              brl   OldWay
3790 F5B2              NewStuff  
3791 F5B2
3792 F5B2              ;-----------------------------------------------------------
3793 F5B2              ; 
3794 F5B2              ; Find out if user has own color table
3795 F5B2              ;
3796 F5B2 A0 00 00              ldy   #ListTemplate.pcount
3797 F5B5 B7 4E                 lda   [parameter],y
3798 F5B7 C9 0F 00              cmp   #15
3799 F5BA D0 14                 bne   UseDefault
3800 F5BC
3801 F5BC A0 2E 00              ldy   #ListTemplate.ColorRef
3802 F5BF B7 4E                 lda   [parameter],y
3803 F5C1 A0 24 00              ldy   #NewCtlRecord.ctlColor
3804 F5C4 97 1D                 sta   [cptr],y
3805 F5C6 A0 30 00              ldy   #ListTemplate.ColorRef+2
3806 F5C9 B7 4E                 lda   [parameter],y
3807 F5CB A0 26 00              ldy   #NewCtlRecord.ctlColor+2
3808 F5CE 97 1D                 sta   [cptr],y
3809 F5D0
3810 F5D0              ;-----------------------------------------------------------
3811 F5D0              ;
3812 F5D0              ; Must set ctlValue and ctlData because newCtl2 does not
3813 F5D0              ; set these.
3814 F5D0              ;
3815 F5D0 A0 1A 00     UseDefault ldy   #ListTemplate.ListSize
3816 F5D3 B7 4E                 lda   [parameter],y
3817 F5D5 A0 1E 00              ldy   #NewCtlRecord.CtlData+2
3818 F5D8 97 1D                 sta   [cPtr],y
3819 F5DA
3820 F5DA 85 11                 sta   <DataSize
3821 F5DC
3822 F5DC A0 1C 00              ldy   #ListTemplate.ListView
3823 F5DF B7 4E                 lda   [parameter],y
3824 F5E1              ;
3825 F5E1              ; if it's zero, calculate what its value by dividing the rect height by memheight
3826 F5E1              ;
3827 F5E1 D0 3B                 bne   Continue
3828 F5E3              ;
3829 F5E3              ; Calculate ListView (the number of items which can be seen at once) by dividing
3830 F5E3              ; the height of the rectangle by listMemHeight.
3831 F5E3              ;
3832 F5E3 48                    pha   
3833 F5E4 48                    pha                            ;space for result of divide
3834 F5E5
3835 F5E5 A0 0A 00              ldy   #ListTemplate.Rect+y2
3836 F5E8 B7 4E                 lda   [parameter],y
3837 F5EA A0 06 00              ldy   #ListTemplate.Rect+y1
3838 F5ED 38                    sec   
3839 F5EE F7 4E                 sbc   [parameter],y
3840 F5F0 48                    pha                            ;height of list record
3841 F5F1 A0 26 00              ldy   #ListTemplate.listMemHeight
3842 F5F4 B7 4E                 lda   [parameter],y            ;height of members
3843 F5F6 48                    pha   
3844 F5F7 A2 0B 0B 22           _UDivide 
3845 F5FE 68                    pla                            ;quotient
3846 F5FF A0 1C 00              ldy   #NewCtlRecord.CtlData
3847 F602 97 1D                 sta   [cPtr],y
3848 F604 85 0F                 sta   <ViewSize
3849 F606 68                    pla                            ;remainder
3850 F607 38                    sec   
3851 F608 E9 02 00              sbc   #2
3852 F60B
3853 F60B 48                    pha   
3854 F60C A0 0A 00              ldy   #ListTemplate.Rect+y2
3855 F60F B7 4E                 lda   [parameter],y
3856 F611 38                    sec   
3857 F612 E3 01                 sbc   1,s
3858 F614 A0 0C 00              ldy   #NewCtlRecord.ctlRect+y2
3859 F617 97 1D                 sta   [cPtr],y
3860 F619 85 19                 sta   <crect+y2
3861 F61B 68                    pla   
3862 F61C 80 07                 bra   Continue1
3863 F61E
3864 F61E A0 1C 00     Continue ldy   #NewCtlRecord.CtlData
3865 F621 97 1D                 sta   [cPtr],y
3866 F623 85 0F                 sta   <ViewSize
3867 F625              Continue1  
3868 F625 A0 1E 00              ldy   #ListTemplate.ListType
3869 F628 B7 4E                 lda   [parameter],y
3870 F62A A0 10 00              ldy   #NewCtlRecord.CtlFlag
3871 F62D
3872 F62D 29 FF 00              and   #$00FF                   ; ListType only a byte value
3873 F630 17 1D                 ora   [<cptr],y                ; Let's just blend things in.
3874 F632 97 1D                 sta   [<cptr],y
3875 F634
3876 F634 A0 20 00              ldy   #ListTemplate.ListStart
3877 F637 B7 4E                 lda   [parameter],y
3878 F639 D0 01                 bne   @1                       ;treat zero and 1 the same
3879 F63B 1A                    inc   a
3880 F63C              @1        
3881 F63C A0 12 00              ldy   #NewCtlRecord.CtlValue
3882 F63F 97 1D                 sta   [cPtr],y
3883 F641
3884 F641              ;
3885 F641              ; Make sure that the top of list is set up so that the no extra
3886 F641              ; lines are shown at the bottom, and that if there are fewer
3887 F641              ; than ViewSize items, the first item is always 1.
3888 F641              ;
3889 F641 A5 11                 lda   <DataSize
3890 F643 38                    sec   
3891 F644 E5 0F                 sbc   <ViewSize
3892 F646 10 03                 bpl   @NotNeg
3893 F648 A9 00 00              lda   #0
3894 F64B 1A           @NotNeg  inc   a
3895 F64C D7 1D                 cmp   [cPtr],y
3896 F64E B0 02                 bcs   @InitialValueGood
3897 F650 97 1D                 sta   [cPtr],y
3898 F652
3899 F652              @InitialValueGood  
3900 F652
3901 F652 A0 2C 00              ldy   #ListTemplate.ListRef+2  ; push these bytes on the stack
3902 F655 B7 4E        @PushLoop lda   [parameter],y           ; from template
3903 F657 48                    pha   
3904 F658 88                    dey   
3905 F659 88                    dey   
3906 F65A C0 22 00              cpy   #ListTemplate.ListDraw
3907 F65D B0 F6                 bcs   @PushLoop
3908 F65F
3909 F65F 80 0D                 bra   PullUm
3910 F661              OldWay    
3911 F661
3912 F661 A0 1E 00              ldy   #ListPointer+2
3913 F664 B7 4E        lop1     lda   [parameter],y
3914 F666 48                    pha   
3915 F667 88                    dey   
3916 F668 88                    dey   
3917 F669 C0 14 00              cpy   #ListDraw
3918 F66C B0 F6                 bcs   lop1
3919 F66E
3920 F66E              PullUm    
3921 F66E
3922 F66E A0 28 00              ldy   #CtlMemDraw              ; pull them back off into ctl record.
3923 F671 68           lop2     pla   
3924 F672 97 1D                 sta   [cptr],y
3925 F674 C8                    iny   
3926 F675 C8                    iny   
3927 F676 C0 34 00              cpy   #CtlListBar
3928 F679 D0 F6                 bne   lop2
3929 F67B
3930 F67B              ;
3931 F67B              ; --- Compute the size and position of the list's scroll bar -----------------
3932 F67B              ;
3933 F67B              ;  If bit 2 of listType is set, the scroll bar goes inside the listrect, otherwise 
3934 F67B              ; it goes on the outside as before.  
3935 F67B              ;
3936 F67B A0 10 00              ldy   #NewCtlRecord.CtlFlag
3937 F67E B7 1D                 lda   [cPtr],y
3938 F680 29 04 00              and   #$0004                   ;on inside or outside?
3939 F683 D0 0A                 bne   Inside
3940 F685
3941 F685 A5 1B                 lda   <crect+x2
3942 F687 3A                    dec   a
3943 F688 3A                    dec   a
3944 F689 85 17                 sta   <crect+x1
3945 F68B 64 1B                 stz   <crect+x2                Let Control Manager compute width.
3946 F68D 80 27                 bra   WidthCalcDone
3947 F68F              ;
3948 F68F              ; Scroll bar goes on inside of list rect.  Also we must shrink the list rect.
3949 F68F              ;
3950 F68F              ;  first clear the bit so that we don't shrink the list rect again
3951 F68F              ;
3952 F68F              Inside    
3953 F68F B7 1D                 lda   [cPtr],y                 ;CtlFlag
3954 F691 29 FB FF              and   #$FFFB                   ;reset bit 2
3955 F694 97 1D                 sta   [cPtr],y
3956 F696              ;
3957 F696              ; Get width of scroll bar
3958 F696              ;
3959 F696 48                    pha                            ;space for result: high word is width
3960 F697 48                    pha                            ;low word is height
3961 F698 A2 10 1E 22           _GrowSize 
3962 F69F
3963 F69F A0 0E 00              ldy   #ctlRect+x2
3964 F6A2 B7 1D                 lda   [cPtr],y
3965 F6A4 38                    sec   
3966 F6A5 E3 03                 sbc   3,s                      ;width of scroll bar
3967 F6A7 1A                    inc   a
3968 F6A8 1A                    inc   a
3969 F6A9 97 1D                 sta   [cPtr],y
3970 F6AB A5 1B                 lda   <crect+x2
3971 F6AD 38                    sec   
3972 F6AE E3 03                 sbc   3,s                      ;width of scroll bar
3973 F6B0 85 17                 sta   <crect+x1
3974 F6B2 64 1B                 stz   <crect+x2
3975 F6B4 68                    pla   
3976 F6B5 68                    pla                            ;clear stack
3977 F6B6
3978 F6B6              WidthCalcDone  
3979 F6B6
3980 F6B6              ;
3981 F6B6              ; --- Create the list's scroll bar -------------------------------------------
3982 F6B6              ;
3983 F6B6 F4 FC 00              pea   listAction>>16           Address of list scroll action procedure
3984 F6B9 F4 C7 F7              pea   listAction               for SetCtlAction call.
3985 F6BC
3986 F6BC 48                    pha                            Space for returned control handle.
3987 F6BD 48                    pha   
3988 F6BE A0 06 00              ldy   #CtlOwner+2              Same window owner as list.
3989 F6C1 20 10 F7              jsr   pushRec
3990 F6C4 20 D5 FA              jsr   pushcrect                Bounds RECT.
3991 F6C7 A9 00 00              lda   #0
3992 F6CA 48                    pha                            Title pointer.
3993 F6CB 48                    pha   
3994 F6CC
3995 F6CC A0 10 00              ldy   #ctlFlag
3996 F6CF B7 1D                 lda   [<cptr],y
3997 F6D1 29 80 00              and   #$0080                   Set scroll bar's visible bit to match list control's
3998 F6D4 09 03 00              ora   #$0003
3999 F6D7 48                    pha                            Pass flag
4000 F6D8
4001 F6D8              ; 4/14/89           Mensch
4002 F6D8              ; make this get the passed list start value. It was using <displayTop which has
4003 F6D8              ; not been initialized yet, it will now load out of the control record
4004 F6D8              ; was    lda   <DisplayTop
4005 F6D8
4006 F6D8 A0 12 00              ldy   #NewCtlRecord.CtlValue
4007 F6DB B7 1D                 lda   [cPtr],y
4008 F6DD
4009 F6DD F0 01                 beq   store2                   Are there any members?
4010 F6DF 3A                    dec   a                        Scroll bar value start at zero.
4011 F6E0 48           store2   pha                            Value.
4012 F6E1
4013 F6E1 D4 0F                 pei   <ViewSize                View size.
4014 F6E3 D4 11                 pei   <DataSize                Data size (number of items in list).
4015 F6E5
4016 F6E5 F4 00 06              pea   $0600                    DefProc, standard scroll bar.
4017 F6E8 F4 00 00              pea   $0000
4018 F6EB
4019 F6EB D4 4C                 pei   <theControl+2            RefCon = list control's handle.
4020 F6ED D4 4A                 pei   <theControl
4021 F6EF
4022 F6EF A9 00 00              lda   #0
4023 F6F2 48                    pha   
4024 F6F3 48                    pha                            ;default color table
4025 F6F4
4026 F6F4 A2 10 09 22           _NewControl                    Create the list scroll bar.
4027 F6FB
4028 F6FB A0 34 00              ldy   #CtlListBar              Store handle of scroll bar in
4029 F6FE A3 01                 lda   1,s                      list's Data area.
4030 F700 97 1D                 sta   [cptr],y
4031 F702 C8                    iny   
4032 F703 C8                    iny   
4033 F704 A3 03                 lda   3,s
4034 F706 97 1D                 sta   [cptr],y
4035 F708
4036 F708 A2 10 20 22           _SetCtlAction                  Set scroll bar's action procedure.
4037 F70F
4038 F70F 60                    rts   
4039 F710
4040 F710                       ENTRY pushRec
4041 F710              pushRec   
4042 F710 FA                    plx   
4043 F711
4044 F711 B7 1D                 lda   [cptr],y
4045 F713 48                    pha   
4046 F714 88                    dey   
4047 F715 88                    dey   
4048 F716 B7 1D                 lda   [cptr],y
4049 F718 48                    pha   
4050 F719
4051 F719 DA                    phx   
4052 F71A 60                    rts   
4053 F71B
4054 F71B                       ENDP 
4055 F71B
4056 F71B
4057 F71B              ;==========================================================================
4058 F71B              ;
4059 F71B              ;                   List_Value
4060 F71B              ;
4061 F71B              ;                   Set new position in list.
4062 F71B              ;
4063 F71B              ;   IN:    cptr = pointer to control.
4064 F71B              ;          CtlValue = new value.
4065 F71B              ;          parameter = new value.
4066 F71B              ;          parameter+2 = old value.
4067 F71B              ;
4068 F71B              ;==========================================================================
4069 F71B                       ENTRY list_value
4070 F71B              list_value PROC export 
4071 F71B
4072 F71B                       import setclip3 
4073 F71B
4074 F71B 20 D5 F2              jsr   startDraw
4075 F71E 20 2D F3              jsr   setClip
4076 F721
4077 F721              ;
4078 F721              ; --- Don't let new value exceed max value ---------------------------
4079 F721              ;
4080 F721 A0 1E 00              ldy   #CtlData+2               Total number of members,
4081 F724 B7 1D                 lda   [cptr],y
4082 F726 88                    dey   
4083 F727 88                    dey   
4084 F728 38                    sec   
4085 F729 F7 1D                 sbc   [cptr],y                 less view.
4086 F72B B0 05                 bcs   ok1                      Can only have one value.
4087 F72D
4088 F72D A9 01 00              lda   #1
4089 F730 80 05                 bra   store1
4090 F732
4091 F732 C5 4E        ok1      cmp   <parameter
4092 F734 B0 08                 bcs   ok2
4093 F736
4094 F736 1A                    inc   a                        Set new max value.
4095 F737 85 4E        store1   sta   <parameter
4096 F739
4097 F739 A0 12 00              ldy   #CtlValue
4098 F73C 97 1D                 sta   [cptr],y
4099 F73E
4100 F73E A0 0F 00     ok2      ldy   #CtlFlag-1               Is the control visible?
4101 F741 B7 1D                 lda   [cptr],y
4102 F743 30 41                 bmi   exit
4103 F745
4104 F745 A5 50                 lda   <parameter+2             Previous value,
4105 F747 38                    sec   
4106 F748 E5 4E                 sbc   <parameter               less new value,
4107 F74A 48                    pha                            equals number of member to scroll.
4108 F74B B0 04                 bcs   ok4
4109 F74D 49 FF FF              eor   #$FFFF                   Make positive.
4110 F750 1A                    inc   a
4111 F751
4112 F751 48           ok4      pha                            Space for multiply result.
4113 F752 48                    pha   
4114 F753 48                    pha                            Number of members to scroll.
4115 F754 D4 13                 pei   <memHeight               Times member's height in pixels.
4116 F756 A2 0B 09 22           _Multiply 
4117 F75D 68                    pla                            Low word is number of pixels to scroll.
4118 F75E FA                    plx                            High word.
4119 F75F F0 03                 beq   ok3                      Is the scroll amount too large?
4120 F761 A9 C8 00              lda   #200                     Bring scroll amount back in range.
4121 F764
4122 F764 7A           ok3      ply   
4123 F765 10 04                 bpl   ok5                      Is the amount to be negative?
4124 F767 49 FF FF              eor   #$FFFF
4125 F76A 1A                    inc   a
4126 F76B
4127 F76B AA           ok5      tax                            Pass amount to scroll in x.
4128 F76C 20 A3 F7              jsr   LST_scroll
4129 F76F
4130 F76F DA                    phx                            Put handle of clobbered region on
4131 F770 48                    pha                            stack for DisposeRgn call.
4132 F771
4133 F771 20 9E F5              jsr   setClip3                 Set clip region to clobbered region.
4134 F774
4135 F774 A5 4E                 lda   <parameter               New first member.
4136 F776 85 0D                 sta   <DisplayTop
4137 F778
4138 F778 64 4E                 stz   <parameter               Set 'draw entire list' flag.
4139 F77A 64 50                 stz   <parameter+2
4140 F77C 20 C4 F1              jsr   draw1Member              Draw the clobbered members.
4141 F77F
4142 F77F A2 04 68 22           _DisposeRgn                    Free clobbered region (already on stack).
4143 F786
4144 F786 20 25 F4     exit     jsr   endDraw                  Terminate drawing.
4145 F789
4146 F789              ;
4147 F789              ; --- Set scroll bar's value ----------------------------------------
4148 F789              ;
4149 F789 A0 12 00              ldy   #CtlValue
4150 F78C B7 1D                 lda   [cptr],y
4151 F78E 3A                    dec   a
4152 F78F 48                    pha   
4153 F790 A0 36 00              ldy   #CtlListBar+2
4154 F793 B7 1D                 lda   [cptr],y
4155 F795 48                    pha   
4156 F796 88                    dey   
4157 F797 88                    dey   
4158 F798 B7 1D                 lda   [cptr],y
4159 F79A 48                    pha   
4160 F79B A2 10 19 22           _SetCtlValue 
4161 F7A2
4162 F7A2 60                    rts   
4163 F7A3
4164 F7A3                       ENDP 
4165 F7A3
4166 F7A3
4167 F7A3              ;==========================================================================
4168 F7A3              ;
4169 F7A3              ;                   LST_Scroll
4170 F7A3              ;
4171 F7A3              ;                   Scroll list's RECT.
4172 F7A3              ;
4173 F7A3              ;   IN:    x = number of pixels to scroll.
4174 F7A3              ;
4175 F7A3              ;==========================================================================
4176 F7A3                       ENTRY LST_scroll
4177 F7A3              LST_scroll PROC 
4178 F7A3
4179 F7A3 DA                    phx                            Save amount to scroll.
4180 F7A4
4181 F7A4 48                    pha                            Allocate clobbered region for scroll.
4182 F7A5 48                    pha   
4183 F7A6 A2 04 67 22           _NewRgn 
4184 F7AD
4185 F7AD 20 D5 FA              jsr   pushcrect                Pass pointer to RECT to scroll.
4186 F7B0 F4 00 00              pea   0                        No horizonal scroll.
4187 F7B3 A3 0B                 lda   11,s                     Number of pixels to scroll vertically.
4188 F7B5 48                    pha   
4189 F7B6
4190 F7B6 A3 0B                 lda   11,s                     Pass region for clobbered region.
4191 F7B8 48                    pha   
4192 F7B9 A3 0B                 lda   11,s
4193 F7BB 48                    pha   
4194 F7BC A2 04 7E 22           _ScrollRect                    Scroll list.
4195 F7C3
4196 F7C3 68                    pla                            Return handle of clobbered region.
4197 F7C4 FA                    plx   
4198 F7C5
4199 F7C5 7A                    ply                            Number of pixels scrolled vertically.
4200 F7C6 60                    rts   
4201 F7C7
4202 F7C7                       ENDP 
4203 F7C7
4204 F7C7
4205 F7C7              ;==========================================================================
4206 F7C7              ;
4207 F7C7              ;                   ListAction
4208 F7C7              ;
4209 F7C7              ;                   List scroll bar action procedure.
4210 F7C7              ;
4211 F7C7              ;   IN:  PUSH:WORD - part code.
4212 F7C7              ;        PUSH:LONG - control handle.
4213 F7C7              ;
4214 F7C7              ;==========================================================================
4215 F7C7                       ENTRY listAction
4216 F7C7              listAction PROC 
4217 F7C7
4218 F7C7              Ctl_ptr  equ   1
4219 F7C7              zpage    equ   Ctl_ptr+4
4220 F7C7              return   equ   zpage+2
4221 F7C7              control  equ   return+3
4222 F7C7              part     equ   control+4
4223 F7C7
4224 F7C7 0B                    phd                            Save original direct page.
4225 F7C8
4226 F7C8 48                    pha                            Space for control pointer.
4227 F7C9 48                    pha   
4228 F7CA
4229 F7CA 3B                    tsc   
4230 F7CB 5B                    tcd   
4231 F7CC
4232 F7CC A7 0A                 lda   [control]                Dereference the control's handle.
4233 F7CE 85 01                 sta   <Ctl_ptr
4234 F7D0 A0 02 00              ldy   #2
4235 F7D3 B7 0A                 lda   [control],y
4236 F7D5 85 03                 sta   <Ctl_ptr+2
4237 F7D7
4238 F7D7 A0 12 00              ldy   #CtlValue
4239 F7DA
4240 F7DA A5 0E                 lda   <part
4241 F7DC 29 7F 00              and   #$7F
4242 F7DF F0 7C                 beq   exit
4243 F7E1 0A                    asl   a
4244 F7E2 AA                    tax   
4245 F7E3 7C E4 F7              jmp   (part_act-2,x)
4246 F7E6
4247 F7E6 39 F8        part_act DC W:act_thumb                 1
4248 F7E8 5D F8                 DC W:act_butt                  2
4249 F7EA 5D F8                 DC W:act_check                 3
4250 F7EC 5D F8                 DC W:act_radio                 4
4251 F7EE F6 F7                 DC W:act_up                    5
4252 F7F0 FE F7                 DC W:act_down                  6
4253 F7F2 03 F8                 DC W:act_pup                   7
4254 F7F4 12 F8                 DC W:act_pdown                 8
4255 F7F6
4256 F7F6 B7 01        act_up   lda   [Ctl_ptr],y
4257 F7F8 38                    sec   
4258 F7F9 E9 01 00              sbc   #1
4259 F7FC 80 0D                 bra   enter1
4260 F7FE
4261 F7FE A9 01 00     act_down lda   #1
4262 F801 80 17                 bra   add_value
4263 F803
4264 F803 B7 01        act_pup  lda   [Ctl_ptr],y              Control's current value.
4265 F805 A0 1C 00              ldy   #CtlData                 Page up the size of the view.
4266 F808 38                    sec   
4267 F809 F7 01                 sbc   [Ctl_ptr],y
4268 F80B B0 20        enter1   bcs   ok2                      Past top?
4269 F80D A9 00 00              lda   #0                       Reset to top.
4270 F810 80 1B                 bra   ok2
4271 F812
4272 F812 A0 1C 00     act_pdown ldy   #CtlData                Page down size of the view.
4273 F815 B7 01                 lda   [Ctl_ptr],y
4274 F817 A0 12 00              ldy   #CtlValue
4275 F81A
4276 F81A 18           add_value clc   
4277 F81B 77 01                 adc   [Ctl_ptr],y              Add to current value.
4278 F81D 48                    pha                            Pass new value.
4279 F81E
4280 F81E A0 1E 00              ldy   #CtlData+2               Make sure new value isn't past max.
4281 F821 B7 01                 lda   [Ctl_ptr],y              Data size,
4282 F823 88                    dey   
4283 F824 88                    dey   
4284 F825 38                    sec   
4285 F826 F7 01                 sbc   [Ctl_ptr],y              less view size equals the maximum value.
4286 F828 C3 01                 cmp   1,s                      Is new value less than max?
4287 F82A B0 02                 bcs   ok3                      If yes, new value on stack is OK.
4288 F82C FA                    plx                            Pop the new value and use the max value.
4289 F82D
4290 F82D              ;
4291 F82D              ; --- Set scroll bar to new value  --------------------------
4292 F82D              ;
4293 F82D 48           ok2      pha                            Put on stack like it is sometimes.
4294 F82E D4 0C        ok3      pei   <control+2
4295 F830 D4 0A                 pei   <control
4296 F832 A2 10 19 22           _SetCtlValue                   Set list scroll bar's value.
4297 F839
4298 F839 A7 0A        act_thumb lda   [control]               Dereference the control's handle.
4299 F83B 85 01                 sta   <Ctl_ptr
4300 F83D A0 02 00              ldy   #2
4301 F840 B7 0A                 lda   [control],y
4302 F842 85 03                 sta   <Ctl_ptr+2
4303 F844
4304 F844 A0 12 00              ldy   #CtlValue                Get value of scroll bar.
4305 F847 B7 01                 lda   [ctl_ptr],y
4306 F849 1A                    inc   a                        List control values start at 1.
4307 F84A 48                    pha                            Pass value to list control.
4308 F84B A0 22 00              ldy   #CtlRefCon+2             Pass handle of list control.
4309 F84E B7 01                 lda   [ctl_ptr],y
4310 F850 48                    pha   
4311 F851 88                    dey   
4312 F852 88                    dey   
4313 F853 B7 01                 lda   [ctl_ptr],y
4314 F855 48                    pha   
4315 F856 A2 10 19 22           _SetCtlValue                   Set list's value.
4316 F85D
4317 F85D              act_butt  
4318 F85D              act_check  
4319 F85D              act_radio  
4320 F85D
4321 F85D 68           exit     pla   
4322 F85E 68                    pla   
4323 F85F 2B                    pld   
4324 F860
4325 F860 A3 00                 lda   0,s
4326 F862 83 06                 sta   6,s
4327 F864 A3 02                 lda   2,s
4328 F866 83 08                 sta   8,s
4329 F868 68                    pla   
4330 F869 68                    pla   
4331 F86A 68                    pla   
4332 F86B 6B                    rtl   
4333 F86C
4334 F86C                       ENDP 
4335 F86C
4336 F86C
4337 F86C              ;                   APPEND LISTDP2.ASM
4338 F86C              ;
4339 F86C              ;==========================================================================
4340 F86C              ;
4341 F86C              ;                   List_New
4342 F86C              ;
4343 F86C              ;                   New list.
4344 F86C              ;
4345 F86C              ;   IN:    parameter = ListRec pointer.
4346 F86C              ;          theControl = handle of list control.
4347 F86C              ;          cptr = list control pointer (locked).
4348 F86C              ;
4349 F86C              ;==========================================================================
4350 F86C                       ENTRY list_new
4351 F86C              list_new PROC 
4352 F86C              ;
4353 F86C              ; --- Set scroll bar's data size and value ----------------------------
4354 F86C              ;
4355 F86C A0 08 00              ldy   #ListSize
4356 F86F B7 4E                 lda   [parameter],y
4357 F871 48                    pha                            New data size.
4358 F872
4359 F872 A0 1E 00              ldy   #CtlData+2               Set list control's data size,
4360 F875 97 1D                 sta   [cptr],y                 while I'm here.
4361 F877
4362 F877 F4 FF FF              pea   $FFFF                    Same view size.
4363 F87A A0 36 00              ldy   #CtlListBar+2            Pass handle of scroll bar.
4364 F87D B7 1D                 lda   [cptr],y
4365 F87F 85 23                 sta   <cworkptr+2
4366 F881 48                    pha   
4367 F882 88                    dey   
4368 F883 88                    dey   
4369 F884 B7 1D                 lda   [cptr],y
4370 F886 85 21                 sta   <cworkptr
4371 F888 48                    pha   
4372 F889 A2 10 1B 22           _SetCtlParams 
4373 F890
4374 F890 A0 0E 00              ldy   #ListStart
4375 F893 B7 4E                 lda   [parameter],y
4376 F895 A0 12 00              ldy   #CtlValue                Set list control's value
4377 F898 97 1D                 sta   [cptr],y
4378 F89A AA                    tax   
4379 F89B F0 01                 beq   store1
4380 F89D 3A                    dec   a
4381 F89E 48           store1   pha   
4382 F89F D4 23                 pei   <cworkptr+2              Pass handle of scroll bar.
4383 F8A1 D4 21                 pei   <cworkptr
4384 F8A3 A2 10 19 22           _SetCtlValue 
4385 F8AA
4386 F8AA A0 1E 00              ldy   #ListPointer+2
4387 F8AD B7 4E                 lda   [parameter],y
4388 F8AF AA                    tax   
4389 F8B0 88                    dey   
4390 F8B1 88                    dey   
4391 F8B2 B7 4E                 lda   [parameter],y
4392 F8B4
4393 F8B4 A0 30 00              ldy   #CtlList
4394 F8B7 97 1D                 sta   [cptr],y
4395 F8B9 C8                    iny   
4396 F8BA C8                    iny   
4397 F8BB 8A                    txa   
4398 F8BC 97 1D                 sta   [cptr],y
4399 F8BE
4400 F8BE 60                    rts   
4401 F8BF
4402 F8BF
4403 F8BF              ; = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = =
4404 F8BF              ;          Draw list control.
4405 F8BF              ;
4406 F8BF              ;   IN:    theControl = handle of list control.
4407 F8BF              ;          cptr = pointer of list control.
4408 F8BF              ;          crect = list control's enclosing RECT.
4409 F8BF              ;          parameter = index of member to draw, or zero to draw entire control.
4410 F8BF              ;
4411 F8BF              ; = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = =
4412 F8BF                       ENTRY list_draw
4413 F8BF A5 4E        list_draw lda   <parameter
4414 F8C1 85 50                 sta   <parameter+2
4415 F8C3
4416 F8C3                       ENTRY list_drawMem
4417 F8C3 A0 10 00     list_drawMem ldy   #CtlFlag             Check the list control's visible state.
4418 F8C6 B7 1D                 lda   [<cptr],y                If its invisible then it means the scroll bar  
4419 F8C8 89 80 00              bit   #$0080                   is also invisible.
4420 F8CB F0 01                 beq   ItsVisible
4421 F8CD 60                    rts   
4422 F8CE
4423 F8CE 20 D5 F2     ItsVisible jsr   startDraw              Set up for drawing.
4424 F8D1
4425 F8D1              ;
4426 F8D1              ; --- Initialize grafPort states ----------------------------------
4427 F8D1              ;
4428 F8D1
4429 F8D1 F4 02 00              pea   2
4430 F8D4 F4 01 00              pea   1
4431 F8D7 A2 04 2C 22           _SetPenSize 
4432 F8DE
4433 F8DE D4 29                 pei   <FrameClr                Outline color.
4434 F8E0 A2 04 37 22           _SetSolidPenPat                Set pen to color of outline.
4435 F8E7
4436 F8E7 20 D5 FA              jsr   pushcrect                Pass address of 'crect'.
4437 F8EA A2 04 53 22           _FrameRect                     Draw frame of list control.
4438 F8F1
4439 F8F1 20 2D F3              jsr   setClip                  Save current clip and set to list.
4440 F8F4
4441 F8F4 A5 4F                 lda   <parameter+1             Asking for whole control?
4442 F8F6 D0 0A                 bne   skip1
4443 F8F8
4444 F8F8 A5 2F                 lda   <NorBackClr              Normal color index.
4445 F8FA A4 2B                 ldy   <NorTextClr              Normal text color.
4446 F8FC 20 53 F3              jsr   setColor
4447 F8FF
4448 F8FF 20 CA F2              jsr   eraseRect                Put down member's background color.
4449 F902
4450 F902 20 C4 F1     skip1    jsr   draw1Member
4451 F905
4452 F905 82 1D FB              brl   endDraw                  Terminate drawing.
4453 F908
4454 F908                       ENDP 
4455 F908
4456 F908              ; = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = =
4457 F908              ;          Hide/Show list control's scroll bar (since this is not part of the
4458 F908              ;          list's control rectangle we need to do things a little differently).
4459 F908              ;
4460 F908              ;   IN:    theControl = handle of list control.
4461 F908              ;          cptr = pointer of list control.
4462 F908              ;          crect = list control's enclosing RECT.
4463 F908              ;          parameter = low word contains the flag which tells us:
4464 F908              ;                      0 = add erased RECT to window's update region, 1 = don't
4465 F908              ;                      2 = show the scroll bar (sent by ShowControl)
4466 F908              ;                      3 = draw the scroll bar (sent by DrawOneCtl)
4467 F908              ;
4468 F908              ; = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = =
4469 F908              list_MultiPart PROC 
4470 F908
4471 F908 A0 34 00              ldy   #ctlListBar              Get handle to the list control's scroll bar
4472 F90B B7 1D                 lda   [<cptr],y
4473 F90D 85 21                 sta   <cworkptr
4474 F90F C8                    iny   
4475 F910 C8                    iny   
4476 F911 B7 1D                 lda   [<cptr],y
4477 F913 85 23                 sta   <cworkptr+2
4478 F915
4479 F915 A0 02 00              ldy   #2                       Dereference the scroll handle
4480 F918 B7 21                 lda   [<cworkptr],y
4481 F91A 85 27                 sta   <cworkptr2+2
4482 F91C A7 21                 lda   [<cworkptr]
4483 F91E 85 25                 sta   <cworkptr2
4484 F920
4485 F920 A5 4E                 lda   <parameter
4486 F922 C9 04 00              cmp   #3+1                     Check to make sure we're not out of range
4487 F925 B0 05                 bcs   NotValid
4488 F927 0A                    asl   a
4489 F928 AA                    tax   
4490 F929 FC 2D F9              jsr   (table,x)
4491 F92C
4492 F92C 60           NotValid rts   
4493 F92D
4494 F92D 35 F9        table    DC W:EraseScroll1              0 erase and add scroll ctl's rect to window's update region
4495 F92F 35 F9                 DC W:EraseScroll2              1 erase and don't add to update region
4496 F931 4F F9                 DC W:ShowScroll                2 show the scroll control
4497 F933 5D F9                 DC W:DrawScroll                3 this message is sent by DrawOneCtl
4498 F935
4499 F935              ;-----------------------------------------------------------------
4500 F935              ;
4501 F935              EraseScroll1  
4502 F935              EraseScroll2  
4503 F935 A5 23 48 A5           PushLong <cworkptr 
4504 F93B A5 4E                 lda   <parameter
4505 F93D F0 08                 beq   HideIt
4506 F93F A2 10 24 22           _EraseControl 
4507 F946 60                    rts   
4508 F947
4509 F947 A2 10 0E 22  HideIt   _HideControl 
4510 F94E 60                    rts   
4511 F94F
4512 F94F
4513 F94F A5 23 48 A5  ShowScroll PushLong <cworkptr 
4514 F955 A2 10 0F 22           _ShowControl 
4515 F95C 60                    rts   
4516 F95D
4517 F95D A0 10 00     DrawScroll ldy   #ctlFlag               Lets see if the scroll bar is visible first before
4518 F960 B7 25                 lda   [<cworkptr2],y           we draw it
4519 F962 29 80 00              and   #$0080
4520 F965 D0 0D                 bne   notVisible
4521 F967
4522 F967 A5 23 48 A5           PushLong <cworkptr 
4523 F96D A2 10 25 22           _DrawOneCtl 
4524 F974
4525 F974 60           notVisible rts   
4526 F975
4527 F975                       ENDP 
4528 F975
4529 F975              ;==========================================================================
4530 F975              ;
4531 F975              ;                   SetNewValue
4532 F975              ;
4533 F975              ;                   Set new value for list.
4534 F975              ;
4535 F975              ;   IN:    a = list's new value.
4536 F975              ;
4537 F975              ;==========================================================================
4538 F975                       ENTRY setNewValue
4539 F975              setNewValue PROC 
4540 F975
4541 F975 48                    pha   
4542 F976 D4 4C                 pei   <theControl+2
4543 F978 D4 4A                 pei   <theControl
4544 F97A
4545 F97A 3A                    dec   a                        Scroll bar needs one less.
4546 F97B 48                    pha   
4547 F97C A0 36 00              ldy   #CtlListBar+2            Pass handle of scroll bar.
4548 F97F 20 10 F7              jsr   pushRec
4549 F982
4550 F982 20 9A F5              jsr   setOldClip               Restore port's clip region.
4551 F985
4552 F985 A2 10 19 22           _SetCtlValue 
4553 F98C A2 10 19 22           _SetCtlValue 
4554 F993
4555 F993
4556 F993                       ENTRY LockNLoad
4557 F993              LockNLoad  
4558 F993 A0 04 00              ldy   #4                       Lock the list control's handle.
4559 F996 B7 4A                 lda   [theControl],y
4560 F998 09 00 80              ora   #$8000
4561 F99B 97 4A                 sta   [theControl],y
4562 F99D 88                    dey                            Derefence the list control's handle.
4563 F99E 88                    dey   
4564 F99F B7 4A                 lda   [theControl],y
4565 F9A1 85 1F                 sta   <cptr+2
4566 F9A3 A7 4A                 lda   [theControl]
4567 F9A5 85 1D                 sta   <cptr
4568 F9A7
4569 F9A7 A5 52                 lda   <operation               If message is initCntl then none of the control rec fields
4570 F9A9 C9 03 00              cmp   #initCntl                have been setup yet so just skip this stuff.
4571 F9AC F0 2B                 beq   ctlListOldWay            We don't need them to be setup for initcntl anyways.
4572 F9AE
4573 F9AE A0 32 00              ldy   #CtlList+2               Get pointer to member list.
4574 F9B1 B7 1D                 lda   [cptr],y
4575 F9B3 85 09                 sta   <memlist+2
4576 F9B5 88                    dey   
4577 F9B6 88                    dey   
4578 F9B7 B7 1D                 lda   [cptr],y
4579 F9B9 85 07                 sta   <memlist
4580 F9BB
4581 F9BB A0 16 00              ldy   #newCtlRecord.ctlProc+2
4582 F9BE B7 1D                 lda   [cptr],y
4583 F9C0 10 17                 bpl   ctlListOldWay
4584 F9C2              ;
4585 F9C2              ; It's a new control record, the ctlList field can be a pointer, handle, or resource
4586 F9C2              ; ID.
4587 F9C2              ;
4588 F9C2 48                    pha                            ;space for result
4589 F9C3 48                    pha   
4590 F9C4
4591 F9C4 A5 09 48 A5           PushLong <memlist 
4592 F9CA
4593 F9CA A0 3C 00              ldy   #newCtlRecord.ctlMoreFlags
4594 F9CD B7 1D                 lda   [cptr],y
4595 F9CF 48                    pha   
4596 F9D0
4597 F9D0 20 FA EA              jsr   LockNDerefList
4598 F9D3
4599 F9D3 68                    pla   
4600 F9D4 85 07                 sta   <memlist
4601 F9D6 68                    pla   
4602 F9D7 85 09                 sta   <memlist+2
4603 F9D9              ctlListOldWay  
4604 F9D9 60                    rts   
4605 F9DA
4606 F9DA                       ENDP 
4607 F9DA
4608 F9DA
4609 F9DA              ;==========================================================================
4610 F9DA              ;
4611 F9DA              ;                   List_First
4612 F9DA              ;
4613 F9DA              ;                   Find first selected member.
4614 F9DA              ;
4615 F9DA              ;==========================================================================
4616 F9DA                       ENTRY list_first
4617 F9DA              list_first PROC 
4618 F9DA
4619 F9DA A9 EB F9              lda   #matchMember
4620 F9DD 20 10 FA              jsr   walkOfLife
4621 F9E0 A5 21                 lda   <cworkptr                Return pointer to member.
4622 F9E2 A6 23                 ldx   <cworkptr+2
4623 F9E4 B0 04                 bcs   exit
4624 F9E6
4625 F9E6 A9 00 00              lda   #0
4626 F9E9 AA                    tax   
4627 F9EA
4628 F9EA 60           exit     rts   
4629 F9EB
4630 F9EB A5 4F        matchMember lda   <parameter+1
4631 F9ED D0 13                 bne   ckMatch
4632 F9EF
4633 F9EF A0 04 00              ldy   #memFlag                 Is this member selected and enabled?
4634 F9F2 B7 21                 lda   [cworkptr],y
4635 F9F4 29 80 00              and   #MEM_SEL
4636 F9F7 F0 15                 beq   exit1                    If not, keep looking.
4637 F9F9
4638 F9F9 B7 21                 lda   [cworkptr],y             Clear member's select bit.
4639 F9FB 29 7F FF              and   #$FF7F
4640 F9FE 97 21                 sta   [cworkptr],y
4641 FA00
4642 FA00 38                    sec                            Quit walk.
4643 FA01 60                    rts   
4644 FA02
4645 FA02
4646 FA02 C5 22        ckMatch  cmp   <cworkptr+1              Is this the starting place?
4647 FA04 D0 08                 bne   exit1
4648 FA06 A5 4E                 lda   <parameter
4649 FA08 C5 21                 cmp   <cworkptr
4650 FA0A D0 02                 bne   exit1
4651 FA0C
4652 FA0C 64 4F                 stz   <parameter+1             Set found flag.
4653 FA0E
4654 FA0E 18           exit1    clc                            Continue walk.
4655 FA0F 60                    rts   
4656 FA10
4657 FA10                       ENDP 
4658 FA10
4659 FA10
4660 FA10              ;==========================================================================
4661 FA10              ;
4662 FA10              ;                   WalkOfLife
4663 FA10              ;
4664 FA10              ;                   Walk the list and perform some action.
4665 FA10              ;
4666 FA10              ;   IN:    a = address less one of routine to call for each member.
4667 FA10              ;          cptr = pointer to list control.
4668 FA10              ;
4669 FA10              ; To Routine:
4670 FA10              ;          cworkptr = pointer to member.
4671 FA10              ;          cworkptr2 = member.
4672 FA10              ;          a = member index.
4673 FA10              ;
4674 FA10              ; Routine out:
4675 FA10              ;          Carry set to quit walk.
4676 FA10              ;          Carry clear to continue walking list.
4677 FA10              ;
4678 FA10              ;  OUT:    Carry set if quit by routine.
4679 FA10              ;          Carry clear if entire list walked.
4680 FA10              ;          a = index of member reached when quit.
4681 FA10              ;
4682 FA10              ; Further Note:
4683 FA10              ;
4684 FA10              ; The routine to be called expects the index of the item being called for
4685 FA10              ; in the a-reg when it is called.
4686 FA10              ;
4687 FA10              ;
4688 FA10              ; Change History
4689 FA10              ;
4690 FA10              ; 30 Aug 88         Steven Glass
4691 FA10              ;
4692 FA10              ; Make this code work in ROM.  (It was self modifying).
4693 FA10              ;
4694 FA10              ; 17 Apr 89         Harry Yee
4695 FA10              ;
4696 FA10              ; We were looping one too many times. If counter = DataSize then we need to exit
4697 FA10              ; the loop otherwise calling GetMemPtr again will access a member that does not
4698 FA10              ; exist.
4699 FA10              ;
4700 FA10              ;==========================================================================
4701 FA10                       ENTRY walkOfLife
4702 FA10              walkOfLife PROC 
4703 FA10                       DefineStack 
4704 FA10              Counter  word 
4705 FA10              ReturnAdr word 
4706 FA10              RoutineAdr word 
4707 FA10
4708 FA10 3A                    dec   a                        subtract 1
4709 FA11 48                    pha                            and put on stack (stays here till end).
4710 FA12
4711 FA12 A9 00 00              lda   #0                       First member.
4712 FA15 80 0B                 bra   enter1
4713 FA17
4714 FA17 48           lop1     pha                            Save counter.
4715 FA18
4716 FA18 20 31 FA              jsr   CallRoutine
4717 FA1B
4718 FA1B 68                    pla                            Get counter.
4719 FA1C B0 11                 bcs   exit2                    Did routine want to quit early?
4720 FA1E
4721 FA1E C5 11                 cmp   <DataSize
4722 FA20 F0 0C                 beq   exit                     Done walking entire list.
4723 FA22
4724 FA22 1A           enter1   inc   a                        Get pointer to next member index.
4725 FA23 48                    pha                            Save counter.
4726 FA24 20 48 FA              jsr   getmemptr                cworkptr = pointer to next member.
4727 FA27 68                    pla                            Restore member counter.
4728 FA28
4729 FA28 C5 11                 cmp   <DataSize                End of list?
4730 FA2A F0 EB                 beq   lop1
4731 FA2C 90 E9                 bcc   lop1
4732 FA2E
4733 FA2E 18           exit     clc   
4734 FA2F 7A           exit2    ply                            Clear routine address of stack.
4735 FA30 60                    rts   
4736 FA31
4737 FA31
4738 FA31 AA           CallRoutine tax   
4739 FA32 A3 05                 lda   RoutineAdr,s             Get routine adr off stack
4740 FA34 48                    pha                            put it on and 
4741 FA35 8A                    txa   
4742 FA36 60                    rts                            rts to it.
4743 FA37
4744 FA37
4745 FA37                       ENDP 
4746 FA37
4747 FA37
4748 FA37              ;
4749 FA37              ;                   APPEND LISTUTIL.ASM
4750 FA37              ;
4751 FA37              ;==========================================================================
4752 FA37              ;
4753 FA37              ;                   InsetCRect
4754 FA37              ;
4755 FA37              ; 3/1/88 Dan - Getmemptr didn't compute the member pointer correctly.
4756 FA37              ;
4757 FA37              ;==========================================================================
4758 FA37                       ENTRY insetcrect
4759 FA37              insetcrect PROC 
4760 FA37
4761 FA37 20 D5 FA              jsr   pushcrect
4762 FA3A F4 02 00              pea   2
4763 FA3D F4 01 00              pea   1
4764 FA40 A2 04 4C 22           _InsetRect 
4765 FA47 60                    rts   
4766 FA48
4767 FA48                       ENDP 
4768 FA48
4769 FA48
4770 FA48              ;==========================================================================
4771 FA48              ;
4772 FA48              ;                   GetMemPtr
4773 FA48              ;
4774 FA48              ;                   Compute pointer to member.
4775 FA48              ;
4776 FA48              ;   IN:    a = index to member, 1 is the first member, and a must not be zero.
4777 FA48              ;          cptr = pointer to list control.
4778 FA48              ;
4779 FA48              ;  OUT:    cworkptr = address of member.
4780 FA48              ;          cworkptr2 = member.
4781 FA48              ;
4782 FA48              ;==========================================================================
4783 FA48                       ENTRY getmemptr
4784 FA48              getmemptr PROC 
4785 FA48
4786 FA48 48                    pha                            Space for result.
4787 FA49 48                    pha   
4788 FA4A 3A                    dec   a
4789 FA4B 48                    pha                            Index number times,
4790 FA4C A0 2E 00              ldy   #CtlMemSize
4791 FA4F B7 1D                 lda   [cptr],y
4792 FA51 48                    pha                            size of member record.
4793 FA52 A2 0B 09 22           _Multiply 
4794 FA59 68                    pla                            Add index to start of member list.
4795 FA5A 18                    clc   
4796 FA5B 65 07                 adc   <memlist
4797 FA5D 85 21                 sta   <cworkptr
4798 FA5F 68                    pla   
4799 FA60 65 09                 adc   <memList+2
4800 FA62 85 23                 sta   <cworkptr+2
4801 FA64
4802 FA64
4803 FA64                       ENTRY derefMem
4804 FA64              derefMem         
4805 FA64
4806 FA64 A0 02 00              ldy   #2                       Dereference pointer to member.
4807 FA67 B7 21                 lda   [cworkptr],y
4808 FA69 85 27                 sta   <cworkptr2+2
4809 FA6B A7 21                 lda   [cworkptr]
4810 FA6D 85 25                 sta   <cworkptr2               cworkptr2 = member.
4811 FA6F
4812 FA6F A0 16 00              ldy   #newCtlRecord.ctlProc+2
4813 FA72 B7 1D                 lda   [cptr],y
4814 FA74 10 48                 bpl   done                     ;old control record.  Do nothing
4815 FA76
4816 FA76              ;
4817 FA76              ; cworkptr2 is either a pointer, handle, or rezID of item
4818 FA76              ;
4819 FA76 A0 04 00              ldy   #4                       ;reserved flag word 4th byte
4820 FA79 B7 21                 lda   [cworkptr],y             ;get flag byte
4821 FA7B 29 03 00              and   #$0003                   ;keep only ptr, handle, rez info
4822 FA7E F0 3E                 beq   done                     ;its a pointer
4823 FA80 3A                    dec   a
4824 FA81 F0 28                 beq   Handle
4825 FA83              ;
4826 FA83              ; cworkptr2 is a rez ID.  See what kind and load resource
4827 FA83              ;
4828 FA83 48                    pha   
4829 FA84 48                    pha                            ;long space for result
4830 FA85
4831 FA85 A0 10 00              ldy   #CtlFlag
4832 FA88 B7 1D                 lda   [cptr],y
4833 FA8A 29 01 00              and   #1
4834 FA8D
4835 FA8D D0 05                 bne   nullType
4836 FA8F              ;
4837 FA8F              ; load P-string
4838 FA8F              ;
4839 FA8F A9 06 80              lda   #rPstring
4840 FA92 80 03                 bra   RezCont
4841 FA94              ;
4842 FA94              ; load C-string
4843 FA94              ;
4844 FA94 A9 1D 80     nullType lda   #rCstring
4845 FA97
4846 FA97              RezCont   
4847 FA97 48                    pha   
4848 FA98 A5 27 48 A5           PushLong <cworkptr2 
4849 FA9E A2 1E 0E 22           _LoadResource 
4850 FAA5 68                    pla   
4851 FAA6 85 25                 sta   <cworkptr2
4852 FAA8 68                    pla   
4853 FAA9 85 27                 sta   <cworkptr2+2
4854 FAAB              ;
4855 FAAB              ; Lock and deref handle
4856 FAAB              ;
4857 FAAB
4858 FAAB A0 04 00     Handle   ldy   #4
4859 FAAE B7 25                 lda   [cworkptr2],y
4860 FAB0              ;
4861 FAB0              ; Don't lock it for now
4862 FAB0              ;	ora	#$8000
4863 FAB0 97 25                 sta   [cworkptr2],y            ;lock it
4864 FAB2 A0 02 00              ldy   #2
4865 FAB5 B7 25                 lda   [cworkptr2],y
4866 FAB7 AA                    tax   
4867 FAB8 A7 25                 lda   [cworkptr2]
4868 FABA 85 25                 sta   <cworkptr2
4869 FABC 86 27                 stx   <cworkptr2+2
4870 FABE              done      
4871 FABE 60                    rts   
4872 FABF
4873 FABF                       ENDP 
4874 FABF
4875 FABF
4876 FABF              ;==========================================================================
4877 FABF              ;
4878 FABF              ;                   GetListRect
4879 FABF              ;
4880 FABF              ;                   Get list control's enclosing RECT.
4881 FABF              ;
4882 FABF              ;==========================================================================
4883 FABF                       ENTRY getlistRect
4884 FABF              getlistRect PROC export 
4885 FABF
4886 FABF A0 0E 00              ldy   #CtlRect+x2
4887 FAC2 A2 06 00              ldx   #x2
4888 FAC5 B7 1D        lop1     lda   [cptr],y
4889 FAC7 95 15                 sta   <crect,x
4890 FAC9 88                    dey   
4891 FACA 88                    dey   
4892 FACB CA                    dex   
4893 FACC CA                    dex   
4894 FACD 10 F6                 bpl   lop1
4895 FACF
4896 FACF 60                    rts   
4897 FAD0
4898 FAD0                       ENDP 
4899 FAD0
4900 FAD0
4901 FAD0              ;==========================================================================
4902 FAD0              ;
4903 FAD0              ;                   PushParam
4904 FAD0              ;
4905 FAD0              ;                   Put address of direct page location on stack.
4906 FAD0              ;
4907 FAD0              ;==========================================================================
4908 FAD0                       ENTRY pushparam
4909 FAD0              pushparam PROC export 
4910 FAD0
4911 FAD0 A9 4E 00              lda   #parameter               Push address of 'paramter' on stack.
4912 FAD3 80 03                 bra   pushzpage
4913 FAD5
4914 FAD5                       ENTRY pushcrect
4915 FAD5              pushcrect  
4916 FAD5 A9 15 00              lda   #crect                   Push address of 'crect' on stack.
4917 FAD8
4918 FAD8                       ENTRY pushzpage
4919 FAD8              pushzpage  
4920 FAD8 FA                    plx                            Get return address.
4921 FAD9
4922 FAD9 F4 00 00              pea   0                        Direct page always in bank zero.
4923 FADC 48                    pha                            Save index.
4924 FADD 7B                    tdc                            Get direct page.
4925 FADE 18                    clc   
4926 FADF 63 01                 adc   1,s                      Add index to direct page.
4927 FAE1 83 01                 sta   1,s
4928 FAE3
4929 FAE3 DA                    phx                            Put return address back.
4930 FAE4
4931 FAE4 60                    rts   
4932 FAE5
4933 FAE5                       ENDP 
4934 FAE5
4935 FAE5
4936 FAE5              ;==========================================================================
4937 FAE5              ;
4938 FAE5              ;                   Long_Call
4939 FAE5              ;
4940 FAE5              ;   IN:    x = middle WORD (bits 8-23) of address of destination routine.
4941 FAE5              ;          a = low WORD of address of destination routine.
4942 FAE5              ;
4943 FAE5              ;  OUT:    Calling this routine is the same as:
4944 FAE5              ;
4945 FAE5              ;                jsl   (ax)
4946 FAE5              ;
4947 FAE5              ;          where the low byte in 'a' is the low byte of the destination
4948 FAE5              ;          address, and x = the next 2 bytes of the destination address.
4949 FAE5              ;
4950 FAE5              ;==========================================================================
4951 FAE5                       ENTRY long_call
4952 FAE5              long_call PROC 
4953 FAE5
4954 FAE5 DA                    phx   
4955 FAE6 8B                    phb   
4956 FAE7 3A                    dec   a                        ;Subtract one from address to call.
4957 FAE8 83 01                 sta   1,s
4958 FAEA
4959 FAEA 6B                    rtl                            ;When the routine called returns, it
4960 FAEB                                                      ;will return to the routine that called
4961 FAEB                                                      ; 'long_call'.
4962 FAEB                       ENDP 
4963 FAEB
4964 FAEB                       END   
4965 FAEB
